/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.quartz.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.quartz.domain.ScheduleJob;
import com.jeeplus.quartz.service.ScheduleJobService;
import java.io.Serializable;
import javax.validation.Valid;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quartz/scheduleJob"})
public class ScheduleJobController {
    @Autowired
    private ScheduleJobService scheduleJobService;

    @PreAuthorize(value="hasAuthority('quartz:scheduleJob:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<ScheduleJob>> data(ScheduleJob scheduleJob, Page<ScheduleJob> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)scheduleJob), ScheduleJob.class);
        IPage result = this.scheduleJobService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity<ScheduleJob> queryById(String id) {
        ScheduleJob scheduleJob = (ScheduleJob)((Object)this.scheduleJobService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)((Object)scheduleJob));
    }

    @PreAuthorize(value="hasAnyAuthority('quartz:scheduleJob:add','quartz:scheduleJob:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody ScheduleJob scheduleJob) {
        if (!CronExpression.isValidExpression((String)scheduleJob.getCronExpression())) {
            return ResponseEntity.badRequest().body((Object)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.scheduleJobService.saveOrUpdate(scheduleJob);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!");
    }

    @PreAuthorize(value="hasAuthority('quartz:scheduleJob:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> deleteAll(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.scheduleJobService.delete((ScheduleJob)((Object)this.scheduleJobService.getById((Serializable)((Object)id))));
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('quartz:scheduleJob:stop')")
    @PostMapping(value={"stop"})
    public ResponseEntity stop(String id) {
        this.scheduleJobService.stopJob((ScheduleJob)((Object)this.scheduleJobService.getById((Serializable)((Object)id))));
        return ResponseEntity.ok((Object)"\u6682\u505c\u6210\u529f!");
    }

    @PreAuthorize(value="hasAuthority('quartz:scheduleJob:startNow')")
    @PostMapping(value={"startNow"})
    public ResponseEntity startNow(String id) {
        this.scheduleJobService.startNowJob((ScheduleJob)((Object)this.scheduleJobService.getById((Serializable)((Object)id))));
        return ResponseEntity.ok((Object)"\u8fd0\u884c\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('quartz:scheduleJob:resume')")
    @PostMapping(value={"resume"})
    public ResponseEntity resume(String id) {
        this.scheduleJobService.restartJob((ScheduleJob)((Object)this.scheduleJobService.getById((Serializable)((Object)id))));
        return ResponseEntity.ok((Object)"\u6062\u590d\u6210\u529f");
    }

    @GetMapping(value={"existsClass"})
    public ResponseEntity existsClass(String className) {
        Class<?> job = null;
        try {
            job = Class.forName(className);
            return ResponseEntity.ok(job);
        }
        catch (ClassNotFoundException e1) {
            return ResponseEntity.badRequest().body((Object)"\u7c7b\u4e0d\u5b58\u5728");
        }
    }
}

