/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.treetable.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.test.treetable.service.CarService;
import com.jeeplus.test.treetable.service.dto.CarDTO;
import com.jeeplus.test.treetable.service.mapstruct.CarWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8f66\u8f86"})
@RestController
@RequestMapping(value={"/test/treetable/car"})
public class CarController {
    @Autowired
    private CarService carService;
    @Autowired
    private CarWrapper carWrapper;

    @ApiLog(value="\u67e5\u8be2\u8f66\u8f86\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u8f66\u8f86\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('test:treetable:car:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<CarDTO>> list(CarDTO carDTO, Page<CarDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)carDTO), CarDTO.class);
        IPage<CarDTO> result = this.carService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u8f66\u8f86\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u8f66\u8f86\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:treetable:car:view','test:treetable:car:add','test:treetable:car:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<CarDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.carService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u8f66\u8f86")
    @ApiOperation(value="\u4fdd\u5b58\u8f66\u8f86")
    @PreAuthorize(value="hasAnyAuthority('test:treetable:car:add','test:treetable:car:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody CarDTO carDTO) {
        this.carService.saveOrUpdate((Object)this.carWrapper.toEntity(carDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u8f66\u8f86\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u8f66\u8f86")
    @ApiOperation(value="\u5220\u9664\u8f66\u8f86")
    @PreAuthorize(value="hasAuthority('test:treetable:car:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.carService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u8f66\u8f86\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u8f66\u8f86\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:treetable:car:export')")
    @GetMapping(value={"export"})
    public void exportFile(CarDTO carDTO, Page<CarDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)carDTO), CarDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"a.id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = this.carService.findPage(page, queryWrapper).getRecords();
        EasyExcelUtils.newInstance((IService)this.carService, (EntityWrapper)this.carWrapper).exportExcel(result, options.getSheetName(), CarDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('test:treetable:car:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.carService, (EntityWrapper)this.carWrapper).importExcel(file, CarDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('test:treetable:car:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u8f66\u8f86\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.carService, (EntityWrapper)this.carWrapper).exportExcel((List)list, "\u8f66\u8f86\u6570\u636e", CarDTO.class, fileName, null, response);
    }
}

