/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.treetable.controller;

import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.test.treetable.domain.CarKind;
import com.jeeplus.test.treetable.service.CarKindService;
import com.jeeplus.test.treetable.service.dto.CarKindDTO;
import com.jeeplus.test.treetable.service.mapstruct.CarKindWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f66\u7cfb"})
@RestController
@RequestMapping(value={"/test/treetable/carKind"})
public class CarKindController {
    @Autowired
    private CarKindService carKindService;
    @Autowired
    private CarKindWrapper carKindWrapper;

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u8f66\u7cfb\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u8f66\u7cfb\u6570\u636e")
    @GetMapping(value={"queryById"})
    public ResponseEntity<CarKindDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.carKindWrapper.toDTO(this.carKindService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u8f66\u7cfb")
    @ApiOperation(value="\u4fdd\u5b58\u8f66\u7cfb")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody CarKindDTO carKindDTO) {
        this.carKindService.saveOrUpdate((CarKind)((Object)this.carKindWrapper.toEntity((Object)carKindDTO)));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u8f66\u7cfb\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u8f66\u7cfb")
    @ApiOperation(value="\u5220\u9664\u8f66\u7cfb")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.carKindService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u8f66\u7cfb\u6210\u529f");
    }

    @ApiLog(value="\u67e5\u8be2\u8f66\u7cfb\u6811\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u8f66\u7cfb\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<CarKindDTO>> treeData(String extId) {
        List rootTree = this.carKindService.treeData(extId).stream().map(arg_0 -> ((CarKindWrapper)this.carKindWrapper).toDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(rootTree);
    }
}

