/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.dp;

import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.buildinginfo.service.BuildingManagementService;
import com.jeeplus.dp.SaleDTO;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.enterpriseinfo.service.dto.EnterpriseInfoDTO;
import com.jeeplus.enterpriseinfo.service.mapstruct.EnterpriseInfoWrapper;
import com.jeeplus.enterpriseproperty.service.EnterprisePropertyService;
import com.jeeplus.qyuser.service.QyUserService;
import com.jeeplus.saleinventory.service.SaleInventoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7535\u8d39"})
@RestController
@RequestMapping(value={"/dp/dp"})
public class DpController {
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;
    @Autowired
    private EnterprisePropertyService enterprisePropertyService;
    @Autowired
    private EnterpriseInfoWrapper enterpriseInfoWrapper;
    @Autowired
    private QyUserService qyUserService;
    @Autowired
    private SaleInventoryService saleInventoryService;
    @Autowired
    private BuildingManagementService buildingManagementService;

    @ApiLog(value="\u4f01\u4e1a\u4fe1\u606f\u7edf\u8ba1")
    @ApiOperation(value="\u4f01\u4e1a\u4fe1\u606f\u7edf\u8ba1")
    @GetMapping(value={"EnterpriseInfoStatistics"})
    public ResponseEntity<HashMap<String, Object>> EnterpriseInfoStatistics(String qyid) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        EnterpriseInfoDTO aa = (EnterpriseInfoDTO)((Object)this.enterpriseInfoWrapper.toDTO(this.enterpriseInfoService.getById((Serializable)((Object)qyid))));
        map.put("name", aa.getName());
        map.put("fzr", aa.getLxr());
        map.put("phone", aa.getPhone());
        map.put("industry", aa.getIndustry());
        map.put("entry_time", aa.getEntryTime());
        map.put("office_area", aa.getOfficeArea());
        map.put("annual_rent", aa.getAnnualRent());
        map.put("total_num", aa.getTotalNumber());
        map.put("xfqcs", aa.getDes10());
        map.put("xfqcsfgq", aa.getDes11());
        HashMap<String, Object> map2 = this.saleInventoryService.getSaleStatistics(qyid);
        if (map2 != null) {
            map.put("lastYearSale", map2.get("lastYearSale").toString());
            map.put("lastYearIncome", map2.get("lastYearIncome").toString());
            map.put("nowYearSale", map2.get("nowYearSale").toString());
            map.put("nowYearIncome", map2.get("nowYearIncome").toString());
        } else {
            map.put("lastYearSale", "");
            map.put("lastYearIncome", "");
            map.put("nowYearSale", "");
            map.put("nowYearIncome", "");
        }
        return ResponseEntity.ok(map);
    }

    @ApiLog(value="\u6309\u56ed\u533a \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @ApiOperation(value="\u6309\u56ed\u533a \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @GetMapping(value={"getSaleStatisticsForPark"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForPark() throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.getSaleStatisticsForPark());
    }

    @ApiLog(value="\u6309\u697c\u5b87 \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @ApiOperation(value="\u6309\u697c\u5b87 \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @GetMapping(value={"getSaleStatisticsForBuilding"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForBuilding() throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.getSaleStatisticsForBuilding());
    }

    @ApiLog(value="\u67e5\u67d0\u4e2a\u56ed\u533a \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @ApiOperation(value="\u67e5\u67d0\u4e2a\u56ed\u533a \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @GetMapping(value={"getSaleStatisticsForOnePark"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForOnePark(String parkid) throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.getSaleStatisticsForOnePark(parkid));
    }

    @ApiLog(value="\u67e5\u67d0\u4e2a\u697c\u5b87 \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @ApiOperation(value="\u67e5\u67d0\u4e2a\u697c\u5b87 \u5bf9\u8f96\u533a\u5185\u7684\u4eba\u5458\u4ece\u6027\u522b\u3001\u5b66\u5386\u3001\u515a\u5458\u3001\u5de5\u9f84\u7b49\u7eac\u5ea6\u8fdb\u884c\u7edf\u8ba1\u5206\u6790")
    @GetMapping(value={"getSaleStatisticsForOneBuilding"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForOneBuilding(String buildingid) throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.getSaleStatisticsForOneBuilding(buildingid));
    }

    @ApiLog(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe")
    @ApiOperation(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe")
    @GetMapping(value={"getSaleStatisticsForYear"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForYear(String lyid, String qyid, String lb) throws Exception {
        List<Object> res = new ArrayList();
        ArrayList result = new ArrayList();
        if (lyid != null && !lyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForYearLyid(lyid, lb);
        }
        if (qyid != null && !qyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForYearQy(qyid, lb);
        }
        if (lyid != null && lyid.equals("") && qyid != null && qyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForYear(lb);
        }
        HashMap<String, Object> y1 = new HashMap<String, Object>();
        HashMap<String, Object> y2 = new HashMap<String, Object>();
        HashMap<String, Object> y3 = new HashMap<String, Object>();
        HashMap<String, Object> y4 = new HashMap<String, Object>();
        HashMap<String, Object> y5 = new HashMap<String, Object>();
        HashMap<String, Object> y6 = new HashMap<String, Object>();
        HashMap<String, Object> y7 = new HashMap<String, Object>();
        HashMap<String, Object> y8 = new HashMap<String, Object>();
        HashMap<String, Object> y9 = new HashMap<String, Object>();
        HashMap<String, Object> y10 = new HashMap<String, Object>();
        HashMap<String, Object> y11 = new HashMap<String, Object>();
        HashMap<String, Object> y12 = new HashMap<String, Object>();
        y1.put("mounth", "1\u6708");
        y2.put("mounth", "2\u6708");
        y3.put("mounth", "3\u6708");
        y4.put("mounth", "4\u6708");
        y5.put("mounth", "5\u6708");
        y6.put("mounth", "6\u6708");
        y7.put("mounth", "7\u6708");
        y8.put("mounth", "8\u6708");
        y9.put("mounth", "9\u6708");
        y10.put("mounth", "10\u6708");
        y11.put("mounth", "11\u6708");
        y12.put("mounth", "12\u6708");
        double qnamount1 = 0.0;
        double qnamount2 = 0.0;
        double qnamount3 = 0.0;
        double qnamount4 = 0.0;
        double qnamount5 = 0.0;
        double qnamount6 = 0.0;
        double qnamount7 = 0.0;
        double qnamount8 = 0.0;
        double qnamount9 = 0.0;
        double qnamount10 = 0.0;
        double qnamount11 = 0.0;
        double qnamount12 = 0.0;
        double jnamount1 = 0.0;
        double jnamount2 = 0.0;
        double jnamount3 = 0.0;
        double jnamount4 = 0.0;
        double jnamount5 = 0.0;
        double jnamount6 = 0.0;
        double jnamount7 = 0.0;
        double jnamount8 = 0.0;
        double jnamount9 = 0.0;
        double jnamount10 = 0.0;
        double jnamount11 = 0.0;
        double jnamount12 = 0.0;
        int currentYear = Year.now().getValue();
        int lastYear = currentYear - 1;
        for (int i = 0; i < res.size(); ++i) {
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-01")) {
                qnamount1 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-02")) {
                qnamount2 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-03")) {
                qnamount3 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-04")) {
                qnamount4 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-05")) {
                qnamount5 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-06")) {
                qnamount6 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-07")) {
                qnamount7 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-08")) {
                qnamount8 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-09")) {
                qnamount9 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-10")) {
                qnamount10 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-11")) {
                qnamount11 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(lastYear + "-12")) {
                qnamount12 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-01")) {
                jnamount1 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-02")) {
                jnamount2 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-03")) {
                jnamount3 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-04")) {
                jnamount4 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-05")) {
                jnamount5 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-06")) {
                jnamount6 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-07")) {
                jnamount7 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-08")) {
                jnamount8 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-09")) {
                jnamount9 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-10")) {
                jnamount10 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (((HashMap)res.get(i)).get("des1").equals(currentYear + "-11")) {
                jnamount11 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
                continue;
            }
            if (!((HashMap)res.get(i)).get("des1").equals(currentYear + "-12")) continue;
            jnamount12 += Double.parseDouble(((HashMap)res.get(i)).get("amount").toString());
        }
        y1.put("qnamount", qnamount1);
        y1.put("jnamount", jnamount1);
        y2.put("qnamount", qnamount2);
        y2.put("jnamount", jnamount2);
        y3.put("qnamount", qnamount3);
        y3.put("jnamount", jnamount3);
        y4.put("qnamount", qnamount4);
        y4.put("jnamount", jnamount4);
        y5.put("qnamount", qnamount5);
        y5.put("jnamount", jnamount5);
        y6.put("qnamount", qnamount6);
        y6.put("jnamount", jnamount6);
        y7.put("qnamount", qnamount7);
        y7.put("jnamount", jnamount7);
        y8.put("qnamount", qnamount8);
        y8.put("jnamount", jnamount8);
        y9.put("qnamount", qnamount9);
        y9.put("jnamount", jnamount9);
        y10.put("qnamount", qnamount10);
        y10.put("jnamount", jnamount10);
        y11.put("qnamount", qnamount11);
        y11.put("jnamount", jnamount11);
        y12.put("qnamount", qnamount12);
        y12.put("jnamount", jnamount12);
        result.add(y1);
        result.add(y2);
        result.add(y3);
        result.add(y4);
        result.add(y5);
        result.add(y6);
        result.add(y7);
        result.add(y8);
        result.add(y9);
        result.add(y10);
        result.add(y11);
        result.add(y12);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe")
    @ApiOperation(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe")
    @GetMapping(value={"getSaleStatisticsForHb"})
    public ResponseEntity<SaleDTO> getSaleStatisticsForHb(String yqid, String lyid, String qyid) throws Exception {
        SaleDTO res = new SaleDTO();
        if (yqid != null && !yqid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbyqid(yqid);
        }
        if (lyid != null && !lyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbLyid(lyid);
        }
        if (qyid != null && !qyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbQy(qyid);
        }
        if (res != null) {
            double a;
            if (Double.parseDouble(res.nowYearLastIncome) == 0.0) {
                res.setIncomeTb("0%");
            } else {
                a = (Double.parseDouble(res.nowYearIncome) - Double.parseDouble(res.nowYearLastIncome)) / Double.parseDouble(res.nowYearLastIncome) * 100.0;
                res.setIncomeTb(a + "%");
            }
            if (Double.parseDouble(res.nowYearLastSale) == 0.0) {
                res.setSaleTb("0%");
            } else {
                a = (Double.parseDouble(res.nowYearSale) - Double.parseDouble(res.nowYearLastSale)) / Double.parseDouble(res.nowYearLastSale) * 100.0;
                res.setSaleTb(a + "%");
            }
            if (Double.parseDouble(res.lastYearIncome) == 0.0) {
                res.setIncomeHb("0%");
            } else {
                a = (Double.parseDouble(res.nowYearIncome) - Double.parseDouble(res.lastYearIncome)) / Double.parseDouble(res.lastYearIncome) * 100.0;
                res.setIncomeHb(a + "%");
            }
            if (Double.parseDouble(res.lastYearSale) == 0.0) {
                res.setSaleHb("0%");
            } else {
                a = (Double.parseDouble(res.nowYearSale) - Double.parseDouble(res.lastYearSale)) / Double.parseDouble(res.lastYearSale) * 100.0;
                res.setSaleHb(a + "%");
            }
        } else {
            res = new SaleDTO();
        }
        return ResponseEntity.ok((Object)res);
    }

    @ApiLog(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe\u7b2c\u4e8c\u7248")
    @ApiOperation(value="\u53bb\u5e74\u6bcf\u6708\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u548c\u672c\u5e74\u5ea6\u6bcf\u6708\u4f01\u4e1a\u7684\u5165\u5e93\u7a0e\u6536\u8d8b\u52bf\u56fe\u7b2c\u4e8c\u7248")
    @GetMapping(value={"getSaleStatisticsForHb2"})
    public ResponseEntity<SaleDTO> getSaleStatisticsForHb2(String yqid, String lyid, String qyid) throws Exception {
        YearMonth lastYearSameMonth;
        YearMonth date;
        HashMap<String, Object> stMonth = this.saleInventoryService.getNewSEMounth();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String smonth = "";
        String lastsmonth = "";
        String emonth = "";
        String lastemonth = "";
        DecimalFormat df2 = new DecimalFormat("#.00");
        if (stMonth.get("des1") != null) {
            smonth = stMonth.get("des1").toString();
            date = YearMonth.parse(smonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastsmonth = lastYearSameMonth.format(formatter);
        }
        if (stMonth.get("des2") != null) {
            emonth = stMonth.get("des2").toString();
            date = YearMonth.parse(emonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastemonth = lastYearSameMonth.format(formatter);
        }
        SaleDTO res = new SaleDTO();
        if (yqid != null && !yqid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbyqid2(yqid, smonth, emonth, lastsmonth, lastemonth);
        }
        if (lyid != null && !lyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbLyid2(lyid, smonth, emonth, lastsmonth, lastemonth);
        }
        if (qyid != null && !qyid.equals("")) {
            res = this.saleInventoryService.getSaleStatisticsForHbQy2(qyid, smonth, emonth, lastsmonth, lastemonth);
        }
        if (res != null) {
            res.setSmonth(smonth);
            res.setEmonth(emonth);
            res.setLastsmonth(lastsmonth);
            res.setLastemonth(lastemonth);
            if (Double.parseDouble(res.lastYearIncome) == 0.0) {
                res.setIncomeHb("0%");
            } else {
                double a = (Double.parseDouble(res.nowYearIncome) - Double.parseDouble(res.lastYearIncome)) / Double.parseDouble(res.lastYearIncome) * 100.0;
                res.setIncomeHb(df2.format(a) + "%");
            }
            if (Double.parseDouble(res.lastYearSale) == 0.0) {
                res.setSaleHb("0%");
            } else {
                double a = (Double.parseDouble(res.nowYearSale) - Double.parseDouble(res.lastYearSale)) / Double.parseDouble(res.lastYearSale) * 100.0;
                res.setSaleHb(df2.format(a) + "%");
            }
        } else {
            res = new SaleDTO();
        }
        return ResponseEntity.ok((Object)res);
    }

    @ApiLog(value="\u672c\u5e74\u5ea6\u5404\u56ed\u533a\u6536\u5165\u7a0e\u6536\u5206\u6790")
    @ApiOperation(value="\u672c\u5e74\u5ea6\u5404\u56ed\u533a\u6536\u5165\u7a0e\u6536\u5206\u6790")
    @GetMapping(value={"getSaleStatisticsForYear2"})
    public ResponseEntity<List<HashMap<String, Object>>> getSaleStatisticsForYear2(String yqid, String lyid) throws Exception {
        YearMonth lastYearSameMonth;
        YearMonth date;
        HashMap<String, Object> stMonth = this.saleInventoryService.getNewSEMounth();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String smonth = "";
        String lastsmonth = "";
        String emonth = "";
        String lastemonth = "";
        DecimalFormat df2 = new DecimalFormat("#.00");
        if (stMonth.get("des1") != null) {
            smonth = stMonth.get("des1").toString();
            date = YearMonth.parse(smonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastsmonth = lastYearSameMonth.format(formatter);
        }
        if (stMonth.get("des2") != null) {
            emonth = stMonth.get("des2").toString();
            date = YearMonth.parse(emonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastemonth = lastYearSameMonth.format(formatter);
        }
        List<Object> res = new ArrayList();
        if (yqid != null && !yqid.equals("")) {
            res = this.saleInventoryService.getNowYearSaleByYqid(yqid, smonth, emonth);
        }
        if (lyid != null && !lyid.equals("")) {
            res = this.saleInventoryService.getNowYearSaleByLyid(lyid, smonth, emonth);
        }
        return ResponseEntity.ok(res);
    }

    @ApiLog(value="\u5bf9\u8857\u9053\u8f96\u533a\u5185\u6309\u56ed\u533a\u4e3a\u5355\u4f4d\uff0c\u5b9e\u73b0\u697c\u5b87\u7684\u6570\u636e\u7edf\u8ba1")
    @ApiOperation(value="\u5bf9\u8857\u9053\u8f96\u533a\u5185\u6309\u56ed\u533a\u4e3a\u5355\u4f4d\uff0c\u5b9e\u73b0\u697c\u5b87\u7684\u6570\u636e\u7edf\u8ba1")
    @GetMapping(value={"getStatisticsForPark"})
    public ResponseEntity<List<HashMap<String, Object>>> getStatisticsForPark() throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.getStatisticsForPark());
    }

    @ApiLog(value="\u5bf9\u8857\u9053\u8f96\u533a\u5185\u6309\u697c\u5b87\u4e3a\u5355\u4f4d\uff0c\u5b9e\u73b0\u697c\u5b87\u7684\u6570\u636e\u7edf\u8ba1")
    @ApiOperation(value="\u5bf9\u8857\u9053\u8f96\u533a\u5185\u6309\u697c\u5b87\u4e3a\u5355\u4f4d\uff0c\u5b9e\u73b0\u697c\u5b87\u7684\u6570\u636e\u7edf\u8ba1")
    @GetMapping(value={"getStatisticsForBuild"})
    public ResponseEntity<List<HashMap<String, Object>>> getStatisticsForBuild(String yqid, String lyid) throws Exception {
        YearMonth lastYearSameMonth;
        YearMonth date;
        HashMap<String, Object> stMonth = this.saleInventoryService.getNewSEMounth();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String smonth = "";
        String lastsmonth = "";
        String emonth = "";
        String lastemonth = "";
        if (stMonth.get("des1") != null) {
            smonth = stMonth.get("des1").toString();
            date = YearMonth.parse(smonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastsmonth = lastYearSameMonth.format(formatter);
        }
        if (stMonth.get("des2") != null) {
            emonth = stMonth.get("des2").toString();
            date = YearMonth.parse(emonth, formatter);
            lastYearSameMonth = date.minus(Period.ofYears(1));
            lastemonth = lastYearSameMonth.format(formatter);
        }
        List<HashMap<String, Object>> list = this.enterpriseInfoService.getStatisticsForBuild2(yqid, lyid, smonth, emonth);
        for (int i = 0; i < list.size(); ++i) {
            String LYMJCount = this.buildingManagementService.getCountLYMJ(list.get(i).get("id").toString());
            BigDecimal totalArea = new BigDecimal(list.get(i).get("building_area").toString());
            BigDecimal occupiedArea = new BigDecimal(LYMJCount);
            String LYMJCountS = totalArea.subtract(occupiedArea).toString();
            list.get(i).put("RZMJ", LYMJCount);
            list.get(i).put("KYMJ", LYMJCountS);
        }
        return ResponseEntity.ok(list);
    }

    @ApiLog(value="\u4f01\u4e1a\u660e\u7ec6\u8868")
    @ApiOperation(value="\u4f01\u4e1a\u660e\u7ec6\u8868")
    @GetMapping(value={"EnterpriseDetailTab"})
    public ResponseEntity<List<HashMap<String, Object>>> EnterpriseDetailTab(String yqid, String lyid, String qyName, String industry) throws Exception {
        return ResponseEntity.ok(this.enterpriseInfoService.EnterpriseDetailTab(yqid, lyid, qyName, industry));
    }

    @ApiLog(value="\u5bfc\u5165\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u7b49\u6570\u636e \u6d4b\u8bd5\u7528")
    @ApiOperation(value="\u5bfc\u5165\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u7b49\u6570\u636e \u6d4b\u8bd5\u7528")
    @GetMapping(value={"ce11"})
    public ResponseEntity<String> ce11() throws Exception {
        return ResponseEntity.ok((Object)"");
    }

    @ApiLog(value="\u5bfc\u5165\u5f00\u7968\u3001\u5165\u5e93\u7b49\u6570\u636e \u6d4b\u8bd5\u7528")
    @ApiOperation(value="\u5bfc\u5165\u5f00\u7968\u3001\u5165\u5e93\u7b49\u6570\u636e \u6d4b\u8bd5\u7528")
    @GetMapping(value={"ce22"})
    public ResponseEntity<String> ce22() throws Exception {
        return ResponseEntity.ok((Object)"");
    }
}

