/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.security.jwt;

import cn.hutool.core.util.StrUtil;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.security.jwt.TokenProvider;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JWTFilter
extends GenericFilterBean {
    private final TokenProvider tokenProvider;
    AuthenticationManager authenticationManager;

    public JWTFilter(TokenProvider tokenProvider, AuthenticationManager authenticationManager) {
        this.tokenProvider = tokenProvider;
        this.authenticationManager = authenticationManager;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean isLogin;
        Object accessTokenObj;
        String loginName;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String token = TokenProvider.resolveToken(request);
        String accessToken = null;
        if (StrUtil.isNotEmpty((CharSequence)token) && StrUtil.isNotEmpty((CharSequence)(loginName = TokenProvider.getLoginName(token))) && (accessTokenObj = RedisUtils.getInstance().get("user:cache:token:" + loginName + ":" + token)) != null) {
            accessToken = accessTokenObj.toString();
            RedisUtils.getInstance().expire("user:cache:token:" + loginName + ":" + token, JeePlusProperties.newInstance().getEXPIRE_TIME());
        }
        boolean bl = isLogin = StrUtil.isNotBlank(accessToken) && !accessToken.equals("kickOut");
        if (isLogin) {
            if (TokenProvider.validateToken(token, accessToken) && SecurityContextHolder.getContext().getAuthentication() == null) {
                Authentication authentication = TokenProvider.getAuthentication(accessToken);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

