/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.sys.domain.Role;
import com.jeeplus.sys.service.RoleService;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/role"})
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;

    @ApiLog(value="\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:role:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<Role>> data(Role role, Page<Role> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)role, Role.class);
        IPage result = this.roleService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u67e5\u8be2\u89d2\u8272")
    @PreAuthorize(value="hasAnyAuthority('sys:role:view','sys:role:add','sys:role:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<RoleDTO> queryById(@RequestParam String id) {
        RoleDTO roleDTO = this.roleService.get(id);
        String newDataRuleIds = "";
        if (roleDTO != null) {
            if (StrUtil.isNotBlank((CharSequence)roleDTO.getDataRuleIds())) {
                for (String rId : roleDTO.getDataRuleIds().split(",")) {
                    newDataRuleIds = newDataRuleIds + "dataRule-" + rId + ",";
                }
            }
            if (newDataRuleIds.length() > 1) {
                roleDTO.setDataRuleIds(newDataRuleIds.substring(0, newDataRuleIds.length() - 1));
            }
            roleDTO.setMenuIdList(this.roleService.queryAllNotChildrenMenuId(roleDTO.getId()));
        }
        return ResponseEntity.ok((Object)roleDTO);
    }

    @ApiLog(value="\u4fdd\u5b58\u89d2\u8272")
    @PreAuthorize(value="hasAnyAuthority('sys:role:assign','sys:role:auth','sys:role:add','sys:role:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody RoleDTO roleDTO) {
        String sysData = "0";
        if (StrUtil.isNotEmpty((CharSequence)roleDTO.getId())) {
            sysData = this.roleService.get(roleDTO.getId()).getSysData();
        }
        if (!UserUtils.getCurrentUserDTO().isAdmin() && ("1".equals(sysData) || "1".equals(roleDTO.getSysData()))) {
            return ResponseEntity.badRequest().body((Object)"\u65e0\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u521b\u5efa/\u4fee\u6539\u7cfb\u7edf\u6570\u636e\u3002");
        }
        this.roleService.saveOrUpdate(roleDTO);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u89d2\u8272\u6210\u529f!");
    }

    @ApiLog(value="\u89d2\u8272\u6388\u6743")
    @PreAuthorize(value="hasAnyAuthority('sys:role:assign','sys:role:auth')")
    @PostMapping(value={"assignAuthorityToRole"})
    public ResponseEntity assignAuthorityToRole(@Valid @RequestBody RoleDTO roleDTO) {
        String sysData = this.roleService.get(roleDTO.getId()).getSysData();
        if (!UserUtils.getCurrentUserDTO().isAdmin() && "1".equals(sysData)) {
            return ResponseEntity.badRequest().body((Object)"\u65e0\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u6b64\u6570\u636e\u3002");
        }
        if (StrUtil.isNotBlank((CharSequence)roleDTO.getDataRuleIds())) {
            String[] ruleIds;
            String dataRuleIds = roleDTO.getDataRuleIds();
            String newDataRuleIds = "";
            for (String ruleId : ruleIds = dataRuleIds.split(",")) {
                if (!ruleId.startsWith("dataRule-")) continue;
                newDataRuleIds = newDataRuleIds + ruleId.substring(9) + ",";
            }
            if (newDataRuleIds.length() > 1) {
                roleDTO.setDataRuleIds(newDataRuleIds.substring(0, newDataRuleIds.length() - 1));
            }
        }
        this.roleService.assignAuthorityToRole(roleDTO);
        return ResponseEntity.ok((Object)"\u89d2\u8272\u6388\u6743\u6210\u529f!");
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u89d2\u8272")
    @PreAuthorize(value="hasAuthority('sys:role:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        StringBuffer msg = new StringBuffer();
        for (String id : ids.split(",")) {
            RoleDTO roleDTO = this.roleService.get(id);
            if (!UserUtils.getCurrentUserDTO().isAdmin() && roleDTO.getSysData().equals("1")) {
                msg.append("\u65e0\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539[" + roleDTO.getName() + "]\u6570\u636e\u3002");
                continue;
            }
            this.roleService.deleteRole(id);
            msg.append("\u5220\u9664\u89d2\u8272[" + roleDTO.getName() + "]\u6210\u529f\u3002");
        }
        return ResponseEntity.ok((Object)msg.toString());
    }

    @ApiLog(value="\u83b7\u53d6\u6240\u5c5e\u89d2\u8272\u7528\u6237")
    @PreAuthorize(value="hasAuthority('sys:role:assign')")
    @GetMapping(value={"assign"})
    public ResponseEntity assign(UserDTO userDTO, Page<UserDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)userDTO, UserDTO.class);
        IPage<UserDTO> result = this.userService.findPageByRole(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @DemoMode
    @ApiLog(value="\u4ece\u89d2\u8272\u4e2d\u79fb\u9664\u7528\u6237")
    @PreAuthorize(value="hasAuthority('sys:role:assign')")
    @DeleteMapping(value={"removeUserFromRole"})
    public ResponseEntity removeUserFromRole(String userId, String roleId) {
        RoleDTO role = this.roleService.get(roleId);
        UserDTO user = this.userService.get(userId);
        if (UserUtils.getCurrentUserDTO().getId().equals(userId) && !UserUtils.getCurrentUserDTO().isAdmin()) {
            return ResponseEntity.badRequest().body((Object)("\u65e0\u6cd5\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u7528\u6237\u3010" + user.getName() + "\u3011\u81ea\u5df1\uff01"));
        }
        if (user.getRoleDTOList().size() <= 1) {
            return ResponseEntity.badRequest().body((Object)("\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u5931\u8d25\uff01\u8fd9\u5df2\u7ecf\u662f\u8be5\u7528\u6237\u7684\u552f\u4e00\u89d2\u8272\uff0c\u4e0d\u80fd\u79fb\u9664\u3002"));
        }
        Boolean flag = this.roleService.removeUserFromRole(role, user);
        if (!flag.booleanValue()) {
            return ResponseEntity.badRequest().body((Object)("\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u5931\u8d25\uff01"));
        }
        return ResponseEntity.ok((Object)("\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u6210\u529f\uff01"));
    }

    @DemoMode
    @ApiLog(value="\u6dfb\u52a0\u7528\u6237\u5230\u89d2\u8272")
    @PreAuthorize(value="hasAuthority('sys:role:assign')")
    @PutMapping(value={"addUserToRole"})
    public ResponseEntity addUserToRole(String roleId, String[] userIds) {
        StringBuilder msg = new StringBuilder();
        int newNum = 0;
        RoleDTO roleDTO = this.roleService.get(roleId);
        for (int i = 0; i < userIds.length; ++i) {
            UserDTO user = this.roleService.addUserToRole(roleDTO, this.userService.get(userIds[i]));
            if (user == null) continue;
            msg.append("<br/>\u65b0\u589e\u7528\u6237\u3010" + user.getName() + "\u3011\u5230\u89d2\u8272\u3010" + roleDTO.getName() + "\u3011\uff01");
            ++newNum;
        }
        return ResponseEntity.ok((Object)("\u5df2\u6210\u529f\u5206\u914d " + newNum + " \u4e2a\u7528\u6237" + msg));
    }

    @ApiLog(value="\u9a8c\u8bc1\u89d2\u8272\u540d\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"validateNotExist"})
    public ResponseEntity validateExist(Role role) {
        role = (Role)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.roleService.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)role.getName()), Role::getName, (Object)role.getName())).eq(StrUtil.isNotBlank((CharSequence)role.getEnName()), Role::getEnName, (Object)role.getEnName())).one();
        if (role == null) {
            return ResponseEntity.ok((Object)true);
        }
        return ResponseEntity.ok((Object)false);
    }
}

