/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.baomidou.mybatisplus.extension.service.IService;
import com.jeeplus.core.excel.ExcelListener;
import com.jeeplus.core.mapstruct.EntityWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class EasyExcelUtils<T> {
    private IService service;
    private EntityWrapper wrapper;

    public static EasyExcelUtils newInstance() {
        return new EasyExcelUtils();
    }

    public static EasyExcelUtils newInstance(IService service, EntityWrapper wrapper) {
        return new EasyExcelUtils(service, wrapper);
    }

    public EasyExcelUtils() {
    }

    public EasyExcelUtils(IService service, EntityWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    public void exportExcel(List<?> list, String sheetName, Class<?> pojoClass, String fileName, Collection<String> includeColumnFieldNames, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        if (includeColumnFieldNames != null) {
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), pojoClass).includeColumnFieldNames(includeColumnFieldNames)).sheet(sheetName).doWrite(list);
        } else {
            EasyExcel.write((OutputStream)response.getOutputStream(), pojoClass).sheet(sheetName).doWrite(list);
        }
    }

    public String importExcel(MultipartFile file, Class<T> pojoClass) throws IOException {
        if (file == null) {
            return "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        ExcelListener excelListener = new ExcelListener(this.service, this.wrapper);
        EasyExcel.read((InputStream)file.getInputStream(), pojoClass, excelListener).sheet().doRead();
        return excelListener.getMessage();
    }

    public IService getService() {
        return this.service;
    }

    public EntityWrapper getWrapper() {
        return this.wrapper;
    }

    public void setService(IService service) {
        this.service = service;
    }

    public void setWrapper(EntityWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasyExcelUtils)) {
            return false;
        }
        EasyExcelUtils other = (EasyExcelUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IService this$service = this.getService();
        IService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        EntityWrapper this$wrapper = this.getWrapper();
        EntityWrapper other$wrapper = other.getWrapper();
        return !(this$wrapper == null ? other$wrapper != null : !this$wrapper.equals(other$wrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EasyExcelUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        EntityWrapper $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : $wrapper.hashCode());
        return result;
    }

    public String toString() {
        return "EasyExcelUtils(service=" + this.getService() + ", wrapper=" + this.getWrapper() + ")";
    }
}

