/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jeeplus.sys.domain.Role;
import com.jeeplus.sys.mapper.RoleMapper;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.service.mapstruct.RoleWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleService
extends ServiceImpl<RoleMapper, Role> {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleWrapper roleWrapper;

    public RoleDTO get(String id) {
        RoleDTO roleDTO = (RoleDTO)this.roleWrapper.toDTO(super.getById((Serializable)((Object)id)));
        roleDTO.setDataRuleIdList(((RoleMapper)this.baseMapper).getDataRuleIdListByRoleId(id));
        roleDTO.setMenuIdList(((RoleMapper)this.baseMapper).getMenuIdListByRoleId(id));
        return roleDTO;
    }

    public RoleDTO getRoleByName(String name) {
        return (RoleDTO)this.roleWrapper.toDTO(((LambdaQueryChainWrapper)this.lambdaQuery().eq(Role::getName, (Object)name)).one());
    }

    public RoleDTO getRoleByEnName(String enName) {
        return (RoleDTO)this.roleWrapper.toDTO(((LambdaQueryChainWrapper)this.lambdaQuery().eq(Role::getEnName, (Object)enName)).one());
    }

    public List<String> queryAllNotChildrenMenuId(String id) {
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            return ((RoleMapper)this.baseMapper).queryAllNotChildrenMenuId(id);
        }
        return Lists.newArrayList();
    }

    @CacheEvict(cacheNames={"user:cache:roleList", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public void saveOrUpdate(RoleDTO roleDTO) {
        Role role = (Role)this.roleWrapper.toEntity(roleDTO);
        super.saveOrUpdate((Object)role);
    }

    @CacheEvict(cacheNames={"user:cache:roleList", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public void assignAuthorityToRole(RoleDTO roleDTO) {
        ((RoleMapper)this.baseMapper).deleteRoleMenu(roleDTO.getId());
        roleDTO.getMenuDTOList().forEach(menuDTO -> ((RoleMapper)this.baseMapper).insertRoleMenu(roleDTO.getId(), menuDTO.getId()));
        ((RoleMapper)this.baseMapper).deleteRoleDataRule(roleDTO.getId());
        roleDTO.getDataRuleDTOList().forEach(dataRuleDTO -> ((RoleMapper)this.baseMapper).insertRoleDataRule(roleDTO.getId(), dataRuleDTO.getId()));
    }

    @CacheEvict(cacheNames={"user:cache:roleList", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public void deleteRole(String id) {
        ((RoleMapper)this.baseMapper).deleteRoleMenu(id);
        ((RoleMapper)this.baseMapper).deleteRoleDataRule(id);
        super.removeById((Serializable)((Object)id));
    }

    public Boolean removeUserFromRole(RoleDTO roleDTO, UserDTO userDTO) {
        List<RoleDTO> roleDTOList = userDTO.getRoleDTOList();
        for (RoleDTO e : roleDTOList) {
            if (!e.getId().equals(roleDTO.getId())) continue;
            roleDTOList.remove(e);
            this.userService.saveOrUpdate(userDTO);
            return true;
        }
        return false;
    }

    public UserDTO addUserToRole(RoleDTO roleDTO, UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        List<String> roleIds = userDTO.getRoleIdList();
        if (roleIds.contains(roleDTO.getId())) {
            return null;
        }
        userDTO.getRoleDTOList().add(roleDTO);
        this.userService.saveOrUpdate(userDTO);
        return userDTO;
    }
}

