/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.errors;

import com.jeeplus.aop.demo.exception.DemoException;
import java.sql.SQLException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@ControllerAdvice
public class ExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTranslator.class);

    @ExceptionHandler(value={Throwable.class, SQLException.class})
    public ResponseEntity handleException(Throwable e) {
        String errMsg = "\u9519\u8bef: " + e.getMessage();
        log.error("{}", e);
        return new ResponseEntity((Object)errMsg, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={DemoException.class})
    public ResponseEntity handleDemoException(Throwable e) {
        String errMsg = e.getMessage();
        log.error("{}", e);
        return new ResponseEntity((Object)errMsg, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity handleUnauthorizedException(Throwable e) {
        String errMsg = "\u6743\u9650\u4e0d\u8db3:" + e.getMessage();
        log.error("{}", e);
        return new ResponseEntity((Object)errMsg, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity handleAuthenticationException(Throwable e) {
        String errMsg = e.getMessage();
        log.error("{}", e);
        return new ResponseEntity((Object)errMsg, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class, MissingServletRequestParameterException.class})
    public ResponseEntity handleBadRequestException(Throwable e) {
        String errMsg = "\u60a8\u63d0\u4ea4\u7684\u53c2\u6570\uff0c\u670d\u52a1\u5668\u65e0\u6cd5\u5904\u7406";
        log.error("{}", e);
        return new ResponseEntity((Object)errMsg, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        ObjectError error = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
        String errMsg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
        log.error("{}", (Throwable)e);
        return new ResponseEntity((Object)errMsg, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity handleBindException(BindException e) {
        ObjectError error = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
        String errMsg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
        log.error("{}", (Throwable)e);
        return new ResponseEntity((Object)errMsg, HttpStatus.BAD_REQUEST);
    }
}

