/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datalink.jdbc;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.jeeplus.database.DataSourceConfig;
import com.jeeplus.database.datalink.service.DataSourceService;
import com.jeeplus.database.datalink.service.dto.DataSourceDTO;
import com.jeeplus.database.datalink.service.mapstruct.DataSourceWrapper;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DBPool {
    private static final Logger log = LoggerFactory.getLogger(DBPool.class);
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataSourceConfig dataSourceConfig;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DefaultDataSourceCreator dataSourceCreator;
    @Autowired
    private DatabaseIdProvider databaseIdProvider;

    public static DBPool getInstance() {
        return (DBPool)SpringUtil.getBean(DBPool.class);
    }

    public boolean test(String driver, String url, String username, String password) {
        try {
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(driver);
            basicDataSource.setUrl(url);
            basicDataSource.setUsername(username);
            basicDataSource.setPassword(password);
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)basicDataSource);
            if (driver.toLowerCase().contains("oracle")) {
                jdbcTemplate.queryForList("select 1 from dual");
            } else {
                jdbcTemplate.queryForList("select 1");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataSource addDs(DataSourceDTO dto) {
        if (this.test(dto.getDriverClassName(), dto.getUrl(), dto.getUsername(), dto.getPassword())) {
            DataSourceProperty dataSourceProperty = new DataSourceProperty();
            BeanUtils.copyProperties((Object)dto, (Object)dataSourceProperty);
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
            DataSource dataSource = this.dataSourceCreator.createDataSource(dataSourceProperty);
            ds.addDataSource(dto.getPollName(), dataSource);
            try {
                String databaseId = this.databaseIdProvider.getDatabaseId(dataSource);
                ApplicationContext applicationContext = SpringUtil.getApplicationContext();
                if (applicationContext != null) {
                    ((SqlSession)applicationContext.getBean(SqlSession.class)).getConfiguration().setDatabaseId(databaseId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dataSource;
        }
        log.error("\u52a0\u8f7d\u6570\u636e\u5e93\u94fe\u63a5\u3010" + dto.getPollName() + "\u3011\u8fde\u63a5\u5931\u8d25");
        return null;
    }

    public String remove(String enName) {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.removeDataSource(enName);
        return "\u5220\u9664\u6210\u529f";
    }

    public Map<String, DataSource> getAllDs() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        return ds.getDataSources();
    }

    public DataSource getDsByEnName(String enName) {
        DynamicRoutingDataSource ds;
        DataSource dataSource;
        if (StrUtil.isBlank((CharSequence)enName)) {
            enName = this.dataSourceConfig.primary;
        }
        if ((dataSource = (DataSource)(ds = (DynamicRoutingDataSource)this.dataSource).getDataSources().get(enName)) == null) {
            dataSource = this.reloadDataSource(enName);
        }
        return dataSource;
    }

    public DataSource getDsById(String dataSourceId) {
        String enName = this.dataSourceService.getById(dataSourceId).getEnName();
        return this.getDsByEnName(enName);
    }

    public JdbcTemplate getJdbcTemplateByEnName(String enName) {
        DataSource dataSource = this.getDsByEnName(enName);
        if (dataSource == null) {
            return null;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplateByDsId(String dataSourceId) {
        String enName = this.dataSourceService.getById(dataSourceId).getEnName();
        return this.getJdbcTemplateByEnName(enName);
    }

    public DataSource reloadDataSource(String enName) {
        if (this.dataSourceService.getByEnName(enName) == null) {
            return null;
        }
        return this.addDs(DataSourceWrapper.INSTANCE.toDTO(this.dataSourceService.getByEnName(enName)));
    }
}

