/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datatable.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.db.sql.SqlUtil;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.google.common.collect.Lists;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.database.DataSourceConfig;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datalink.service.DataSourceService;
import com.jeeplus.database.datatable.constants.FieldTypes;
import com.jeeplus.database.datatable.dto.TableDTO;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/database/table"})
public class TableController {
    @Autowired
    DataSourceService dataSourceService;
    @Autowired
    DynamicDataSourceProperties dynamicDataSourceProperties;
    @Autowired
    DataSourceConfig dataSourceConfig;

    public static Object getValueStr(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Clob) {
            return SqlUtil.clobToStr((Clob)((Clob)obj));
        }
        if (obj instanceof Blob) {
            return SqlUtil.blobToStr((Blob)((Blob)obj), (Charset)CharsetUtil.CHARSET_UTF_8);
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str((byte[])rowId.getBytes(), (Charset)CharsetUtil.CHARSET_UTF_8);
        }
        if (obj instanceof Timestamp) {
            long time = ((Timestamp)obj).getTime() / 1000L;
            return DateUtil.date((long)time);
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        return obj;
    }

    private static void assertDataSourceNotNull(DataSource dataSource) {
        Validate.validState((dataSource != null ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u94fe\u63a5\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
    }

    @GetMapping(value={"list"})
    public ResponseEntity data(@RequestParam(value="dataSourceId") String dataSourceId) {
        DataSource dataSource = DBPool.getInstance().getDsById(dataSourceId);
        TableController.assertDataSourceNotNull(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        try {
            Table[] tables = platform.getTablesWithoutColumn();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rows", tables);
            map.put("total", tables.length);
            return ResponseEntity.ok(map);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(value={"/create"})
    public ResponseEntity queryCreate(@RequestParam(value="dataSourceId") String dataSourceId) throws Exception {
        DataSource dataSource = DBPool.getInstance().getDsById(dataSourceId);
        TableController.assertDataSourceNotNull(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        Connection conn = platform.getDataSource().getConnection();
        Table table = new Table();
        table.setCatalog(conn.getCatalog());
        String _databaseType = new PlatformUtils().determineDatabaseType(dataSource);
        if (!"MsSql".equals(_databaseType)) {
            table.setSchema(conn.getSchema());
        }
        conn.close();
        return ResponseUtil.newInstance().add("table", (Object)table).add("columnTypes", (Object)Lists.newArrayList((Object[])FieldTypes.class.getDeclaredFields())).ok();
    }

    @DemoMode
    @PostMapping(value={"/create/do"})
    public ResponseEntity doCreate(@RequestBody TableDTO tableDTO) {
        try {
            DataSource dataSource = DBPool.getInstance().getDsById(tableDTO.getDataSourceId());
            TableController.assertDataSourceNotNull(dataSource);
            Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
            Table eqTable = platform.getTable(tableDTO.getName());
            if (ObjectUtil.isNotNull((Object)eqTable)) {
                return ResponseEntity.badRequest().body((Object)("\u8868 '" + tableDTO.getName() + "' \u5df2\u5b58\u5728\uff01"));
            }
            Table table = new Table();
            table.setName(tableDTO.getName());
            table.setSchema(tableDTO.getSchema());
            table.setCatalog(tableDTO.getCatalog());
            table.setDescription(tableDTO.getDescription());
            for (Column column : tableDTO.getColumns()) {
                table.addColumn(column);
            }
            platform.createTable(table, false, false);
            return ResponseEntity.ok((Object)"\u521b\u5efa\u6210\u529f!");
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/alter"})
    public ResponseEntity queryAlter(@RequestParam(value="dataSourceId") String dataSourceId, @RequestParam(value="name") String name) throws Exception {
        DataSource dataSource = DBPool.getInstance().getDsById(dataSourceId);
        TableController.assertDataSourceNotNull(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        Table table = platform.getTable(name);
        return ResponseUtil.newInstance().add("table", (Object)table).add("columnTypes", (Object)Lists.newArrayList((Object[])FieldTypes.class.getDeclaredFields())).ok();
    }

    @DemoMode
    @PostMapping(value={"/alter/do"})
    public ResponseEntity doAlter(@RequestBody TableDTO tableDTO) throws SQLException {
        DataSource dataSource = DBPool.getInstance().getDsById(tableDTO.getDataSourceId());
        TableController.assertDataSourceNotNull(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        Table table = new Table();
        table.setName(tableDTO.getName());
        table.setSchema(tableDTO.getSchema());
        table.setCatalog(tableDTO.getCatalog());
        table.setDescription(tableDTO.getDescription());
        for (Column column : tableDTO.getColumns()) {
            table.addColumn(column);
        }
        Table eqTable = platform.getTable(table.getName());
        platform.alterTable(eqTable, table, false);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @DemoMode
    @DeleteMapping(value={"/drop"})
    public ResponseEntity doDrop(@RequestParam(value="dataSourceId") String dataSourceId, String tableName) throws SQLException {
        DataSource dataSource = DBPool.getInstance().getDsById(dataSourceId);
        TableController.assertDataSourceNotNull(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        platform.dropTable(tableName);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/executeSql/{name}"})
    public ResponseEntity executeSql(@RequestParam(value="dataSourceId") String dataSourceId, @PathVariable(value="name") String name) throws Exception {
        DataSource dataSource = DBPool.getInstance().getDsById(dataSourceId);
        TableController.assertDataSourceNotNull(dataSource);
        List result = Db.use((DataSource)dataSource).findAll(name).stream().map(this::transferEntity).collect(Collectors.toList());
        Platform platform = PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        Column[] columns = platform.getTableColumnList(name);
        return ResponseUtil.newInstance().add("list", result).add("columns", (Object)columns).ok();
    }

    public Entity transferEntity(Entity entity) {
        for (String key : entity.keySet()) {
            Object newValue = TableController.getValueStr(entity.get((Object)key));
            entity.put(key, newValue);
        }
        return entity;
    }
}

