/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.office.conroller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.office.domain.DocTemplate;
import com.jeeplus.office.service.DocTemplateService;
import com.jeeplus.office.service.dto.DocTemplateDTO;
import com.jeeplus.office.service.mapstruct.DocTemplateWrapper;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wps/docTemplate"})
public class DocTemplateController {
    @Autowired
    private DocTemplateService docTemplateService;
    @Autowired
    private DocTemplateWrapper docTemplateWrapper;

    @PreAuthorize(value="hasAuthority('wps:docTemplate:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<DocTemplateDTO>> list(DocTemplateDTO docTemplateDTO, Page<DocTemplateDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)docTemplateDTO), DocTemplateDTO.class);
        IPage<DocTemplateDTO> result = this.docTemplateService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @PreAuthorize(value="hasAnyAuthority('wps:docTemplate:view','wps:docTemplate:add','wps:docTemplate:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DocTemplateDTO> queryById(String id) {
        DocTemplateDTO docTemplateDTO = this.docTemplateWrapper.toDTO((DocTemplate)((Object)this.docTemplateService.getById((Serializable)((Object)id))));
        return ResponseEntity.ok((Object)((Object)docTemplateDTO));
    }

    @PreAuthorize(value="hasAnyAuthority('wps:docTemplate:add','wps:docTemplate:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody @Valid DocTemplateDTO docTemplateDTO) {
        DocTemplate docTemplate = this.docTemplateWrapper.toEntity(docTemplateDTO);
        this.docTemplateService.saveOrUpdate((Object)docTemplate);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6587\u6863\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('wps:docTemplate:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.docTemplateService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u6587\u6863\u6210\u529f");
    }
}

