/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.shop.controller;

import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.test.shop.service.CategoryService;
import com.jeeplus.test.shop.service.dto.CategoryDTO;
import com.jeeplus.test.shop.service.mapstruct.CategoryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7c7b\u578b"})
@RestController
@RequestMapping(value={"/test/shop/category"})
public class CategoryController {
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private CategoryWrapper categoryWrapper;

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:shop:category:view','test:shop:category:add','test:shop:category:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<CategoryDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.categoryService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b")
    @ApiOperation(value="\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b")
    @PreAuthorize(value="hasAnyAuthority('test:shop:category:add','test:shop:category:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody CategoryDTO categoryDTO) {
        this.categoryService.saveOrUpdate(this.categoryWrapper.toEntity(categoryDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ApiOperation(value="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @PreAuthorize(value="hasAuthority('test:shop:category:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.categoryService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5546\u54c1\u7c7b\u578b\u6210\u529f");
    }

    @ApiLog(value="\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u6811\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<CategoryDTO>> treeData(String extId) {
        List rootTree = this.categoryService.treeDataDTO(extId);
        return ResponseEntity.ok((Object)rootTree);
    }
}

