/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.extra.servlet.ServletUtil;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.common.utils.RequestUtils;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.security.jwt.TokenProvider;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.constant.enums.LogTypeEnum;
import com.jeeplus.sys.model.LoginForm;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/sys/login"})
    @ApiLog(value="\u7528\u6237\u767b\u5f55", type=LogTypeEnum.LOGIN)
    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    public ResponseEntity login(@RequestBody LoginForm loginForm) {
        ResponseUtil responseUtil = new ResponseUtil();
        String username = loginForm.getUsername();
        String password = loginForm.getPassword();
        String code = loginForm.getCode();
        SecurityUtils.login(username, password, this.authenticationManager);
        if (!this.userService.isEnableLogin(username)) {
            throw new DisabledException("\u60a8\u7684\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u5730\u65b9\u767b\u5f55\uff0c\u60a8\u88ab\u7981\u6b62\u767b\u5f55\uff01");
        }
        UserDTO userDTO = UserUtils.getByLoginName(username);
        String token = TokenProvider.createAccessToken(username, userDTO.getPassword());
        responseUtil.add("token", (Object)token);
        this.updateUserLoginInfo(responseUtil, userDTO, token);
        return responseUtil.ok();
    }

    @ApiLog(value="\u5355\u70b9\u767b\u5f55", type=LogTypeEnum.ACCESS)
    @RequestMapping(value={"/sys/casLogin"})
    public ResponseEntity casLogin(@RequestParam(name="ticket") String ticket, @RequestParam(name="service") String service, @Value(value="${cas.server-url-prefix}") String casServer) throws Exception {
        Cas20ServiceTicketValidator ticketValidator = new Cas20ServiceTicketValidator(casServer);
        ResponseUtil responseUtil = new ResponseUtil();
        try {
            Assertion casAssertion = ticketValidator.validate(ticket, service);
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String loginName = casPrincipal.getName();
            UserDTO userDTO = UserUtils.getByLoginName(loginName);
            if (userDTO != null) {
                if ("0".equals(userDTO.getLoginFlag())) {
                    throw new LockedException("\u8be5\u5e10\u53f7\u5df2\u7ecf\u88ab\u7981\u6b62\u767b\u5f55\uff01");
                }
                String token = TokenProvider.createAccessToken(userDTO.getLoginName(), userDTO.getPassword());
                Authentication authentication = TokenProvider.getAuthentication(token);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                responseUtil.add("token", (Object)token);
                this.updateUserLoginInfo(responseUtil, userDTO, token);
                return responseUtil.ok();
            }
            UsernameNotFoundException e = new UsernameNotFoundException("\u7528\u6237\u540d\u4e0d\u5b58\u5728!");
            log.error("\u7528\u6237\u3010loginName:" + loginName + "\u3011\u4e0d\u5b58\u5728!", (Throwable)e);
            throw e;
        }
        catch (TicketValidationException e) {
            log.error("Unable to validate ticket [" + ticket + "]", (Throwable)e);
            throw new CredentialsExpiredException("\u672a\u901a\u8fc7\u9a8c\u8bc1\u7684ticket [" + ticket + "]", (Throwable)e);
        }
    }

    private void updateUserLoginInfo(ResponseUtil responseUtil, UserDTO userDTO, String token) {
        String username = userDTO.getLoginName();
        this.redisUtils.set("user:cache:token:" + username + ":" + token, (Object)token);
        this.redisUtils.expire("user:cache:token:" + username + ":" + token, JeePlusProperties.newInstance().getEXPIRE_TIME());
        responseUtil.add("oldLoginDate", (Object)userDTO.getLoginDate());
        responseUtil.add("oldLoginIp", (Object)userDTO.getLoginIp());
        userDTO.setLoginDate(new Date());
        userDTO.setLoginIp(ServletUtil.getClientIP((HttpServletRequest)RequestUtils.getRequest(), (String[])new String[0]));
        this.userService.updateUserLoginInfo(userDTO);
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @ApiLog(value="\u9000\u51fa\u767b\u5f55", type=LogTypeEnum.LOGIN)
    @GetMapping(value={"/sys/logout"})
    public ResponseEntity logout(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityUtils.getAuthentication();
        if (auth != null) {
            UserUtils.deleteCache(UserUtils.getCurrentUserDTO());
            String token = TokenProvider.resolveToken(request);
            this.redisUtils.delete("user:cache:token:" + TokenProvider.getLoginName(token) + ":" + token);
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return ResponseEntity.ok((Object)"\u9000\u51fa\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @ApiLog(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/sys/getCode"})
    public ResponseEntity getCode() {
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)116, (int)36, (int)4, (int)50);
        String uuid = UUID.randomUUID().toString();
        RedisUtils.getInstance().set("sys:cache:code", uuid, (Object)lineCaptcha.getCode());
        RedisUtils.getInstance().expire("sys:cache:code", uuid, 300L);
        return ResponseUtil.newInstance().add("codeImg", (Object)lineCaptcha.getImageBase64()).add("uuid", (Object)uuid).ok();
    }
}

