/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.sys.service.DictTypeService;
import com.jeeplus.sys.service.dto.DictTypeDTO;
import com.jeeplus.sys.service.dto.DictValueDTO;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DictUtils {
    public static String getDictLabel(String value, String type, String defaultLabel) {
        if (StrUtil.isNotBlank((CharSequence)type) && StrUtil.isNotBlank((CharSequence)value)) {
            for (DictValueDTO dictValueDTO : DictUtils.getDictDTOList(type)) {
                if (!value.equals(dictValueDTO.getValue())) continue;
                return dictValueDTO.getLabel();
            }
        }
        return defaultLabel;
    }

    public static String getDictLabels(String values, String type, String defaultValue) {
        if (StrUtil.isNotBlank((CharSequence)type) && StrUtil.isNotBlank((CharSequence)values)) {
            ArrayList valueList = Lists.newArrayList();
            for (String value : StrUtil.split((CharSequence)values, (CharSequence)",")) {
                valueList.add(DictUtils.getDictLabel(value, type, defaultValue));
            }
            return StringUtils.join((Collection)valueList, (String)",");
        }
        return defaultValue;
    }

    public static String getDictValue(String label, String type, String defaultLabel) {
        if (StrUtil.isNotBlank((CharSequence)type) && StrUtil.isNotBlank((CharSequence)label)) {
            for (DictValueDTO dictValue : DictUtils.getDictDTOList(type)) {
                if (!label.equals(dictValue.getLabel())) continue;
                return dictValue.getValue();
            }
        }
        return defaultLabel;
    }

    public static List<DictValueDTO> getDictDTOList(String type) {
        Map<String, List<DictValueDTO>> dictMap = DictUtils.getDictMap();
        ArrayList dictList = dictMap.get(type);
        if (dictList == null) {
            dictList = Lists.newArrayList();
        }
        return dictList;
    }

    public static Map<String, List<DictValueDTO>> getDictMap() {
        HashMap dictMap = Maps.newHashMap();
        List<DictTypeDTO> dict = ((DictTypeService)((Object)SpringUtil.getBean(DictTypeService.class))).getDict();
        for (DictTypeDTO dictTypeDTO : dict) {
            dictMap.put(dictTypeDTO.getType(), dictTypeDTO.getDictValueDTOList());
        }
        return dictMap;
    }

    public static Object getValue(Object obj, String filed) {
        try {
            Class<?> clazz = obj.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(filed, clazz);
            Method getMethod = pd.getReadMethod();
            if (pd != null) {
                Object o = getMethod.invoke(obj, new Object[0]);
                return o;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

