/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.saleinventory.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.enterpriseinfo.service.EnterpriseInfoService;
import com.jeeplus.saleinventory.domain.SaleInventory;
import com.jeeplus.saleinventory.service.SaleInventoryService;
import com.jeeplus.saleinventory.service.dto.SaleInventoryDTO;
import com.jeeplus.saleinventory.service.mapstruct.SaleInventoryWrapper;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93"})
@RestController
@RequestMapping(value={"/saleinventory/saleInventory"})
public class SaleInventoryController {
    @Autowired
    private SaleInventoryService saleInventoryService;
    @Autowired
    private SaleInventoryWrapper saleInventoryWrapper;
    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @ApiLog(value="\u67e5\u8be2\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('saleinventory:saleInventory:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<SaleInventoryDTO>> list(SaleInventoryDTO saleInventoryDTO, Page<SaleInventoryDTO> page) throws Exception {
        String officeid;
        String qyid;
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)saleInventoryDTO), SaleInventoryDTO.class);
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        String[] roleIds = userDTO.getRoleIds().split(",");
        if (Arrays.asList(roleIds).contains("38a14f1f42ed424eab4cb5d489596b0d") && (qyid = this.enterpriseInfoService.findQyidByOfficeid(officeid = userDTO.getOfficeDTO().getId())) != null && !qyid.equals("")) {
            queryWrapper.eq((Object)"a.qi_id", (Object)qyid);
        }
        if (saleInventoryDTO.getDes10() != null && !saleInventoryDTO.getDes10().equals("")) {
            queryWrapper.eq((Object)"b.des1", (Object)saleInventoryDTO.getDes10());
        }
        IPage<SaleInventoryDTO> result = this.saleInventoryService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('saleinventory:saleInventory:view','saleinventory:saleInventory:add','saleinventory:saleInventory:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<SaleInventoryDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.saleInventoryService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93")
    @PreAuthorize(value="hasAnyAuthority('saleinventory:saleInventory:add','saleinventory:saleInventory:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody SaleInventoryDTO saleInventoryDTO) {
        if (saleInventoryDTO.getDes3() == null || !saleInventoryDTO.getDes3().equals("1")) {
            saleInventoryDTO.setDes3("0");
        }
        this.saleInventoryService.saveOrUpdate((Object)this.saleInventoryWrapper.toEntity(saleInventoryDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93")
    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93")
    @PreAuthorize(value="hasAuthority('saleinventory:saleInventory:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.saleInventoryService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('saleinventory:saleInventory:export')")
    @GetMapping(value={"export"})
    public void exportFile(SaleInventoryDTO saleInventoryDTO, Page<SaleInventoryDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)saleInventoryDTO), SaleInventoryDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"a.id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = this.saleInventoryService.findPage(page, queryWrapper).getRecords();
        EasyExcelUtils.newInstance((IService)this.saleInventoryService, (EntityWrapper)this.saleInventoryWrapper).exportExcel(result, options.getSheetName(), SaleInventoryDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('saleinventory:saleInventory:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.saleInventoryService, (EntityWrapper)this.saleInventoryWrapper).importExcel(file, SaleInventoryDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('saleinventory:saleInventory:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.saleInventoryService, (EntityWrapper)this.saleInventoryWrapper).exportExcel((List)list, "\u4f01\u4e1a\u9500\u552e\u53ca\u5165\u5e93\u6570\u636e", SaleInventoryDTO.class, fileName, null, response);
    }

    @ApiLog(value="\u5ba1\u6838")
    @ApiOperation(value="\u5ba1\u6838")
    @PreAuthorize(value="hasAuthority('saleinventory:saleInventory:ko')")
    @PostMapping(value={"ko"})
    public ResponseEntity<String> keepOnRecord(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(BaseEntity::getId, (Object)id)).set(SaleInventory::getDes4, (Object)1);
            this.saleInventoryService.update(null, (Wrapper)lambdaUpdateWrapper);
        }
        return ResponseEntity.ok((Object)"\u5ba1\u6838\u6210\u529f");
    }
}

