/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.sys.service.LogService;
import com.jeeplus.sys.service.dto.LogDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/log"})
public class LogController {
    @Autowired
    private LogService logService;

    @ApiLog(value="\u65e5\u5fd7\u5217\u8868")
    @PreAuthorize(value="hasAuthority('sys:log:list')")
    @GetMapping(value={"list"})
    public ResponseEntity data(LogDTO logDTO, Page<LogDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)logDTO, LogDTO.class);
        IPage<LogDTO> result = this.logService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u6211\u7684\u65e5\u5fd7")
    @GetMapping(value={"data/mine"})
    public ResponseEntity mine(LogDTO logDTO, Page<LogDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)logDTO, LogDTO.class);
        IPage<LogDTO> result = this.logService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @ApiLog(value="\u5220\u9664\u65e5\u5fd7")
    @PreAuthorize(value="hasAuthority('sys:log:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        this.logService.removeByIds(Lists.newArrayList((Object[])ids.split(",")));
        return ResponseEntity.ok((Object)"\u5220\u9664\u65e5\u5fd7\u6210\u529f\uff01");
    }

    @ApiLog(value="\u6e05\u7a7a\u65e5\u5fd7")
    @PreAuthorize(value="hasAuthority('sys:log:del')")
    @DeleteMapping(value={"empty"})
    public ResponseEntity empty() {
        this.logService.remove((Wrapper)new QueryWrapper());
        return ResponseEntity.ok((Object)"\u6e05\u7a7a\u65e5\u5fd7\u6210\u529f!");
    }
}

