/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.datav.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.datav.domain.DataMap;
import com.jeeplus.datav.service.DataMapService;
import com.jeeplus.datav.service.dto.DataMapDTO;
import com.jeeplus.datav.service.mapstruct.DataMapWrapper;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datav/dataMap"})
public class DataMapController {
    @Autowired
    private DataMapService dataMapService;
    @Autowired
    private DataMapWrapper dataMapWrapper;

    @ApiLog(value="\u67e5\u8be2\u5730\u56fe\u5217\u8868")
    @PreAuthorize(value="hasAuthority('datav:dataMap:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<DataMap>> list(DataMap dataMap, Page<DataMap> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)dataMap), DataMap.class);
        IPage result = this.dataMapService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('datav:dataMap:view','datav:dataMap:add','datav:dataMap:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DataMap> queryById(String id) {
        DataMap dataMap = (DataMap)((Object)this.dataMapService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)((Object)dataMap));
    }

    @GetMapping(value={"getMapData"})
    public Object getMapData(String id) {
        DataMap dataMap = (DataMap)((Object)this.dataMapService.getById((Serializable)((Object)id)));
        return dataMap.getData();
    }

    @PreAuthorize(value="hasAnyAuthority('datav:dataMap:add','datav:dataMap:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody @Valid DataMapDTO dataMapDTO) {
        DataMap dataMap = (DataMap)((Object)this.dataMapWrapper.toEntity((Object)dataMapDTO));
        this.dataMapService.saveOrUpdate((Object)dataMap);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5730\u56fe\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('datav:dataMap:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.dataMapService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5730\u56fe\u6210\u529f");
    }
}

