/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jeeplus.database.datalink.domain.DataSource;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datalink.service.DataSourceService;
import com.jeeplus.database.datalink.service.dto.DataSourceDTO;
import com.jeeplus.database.datalink.service.mapstruct.DataSourceWrapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataSourceConfig
implements ApplicationRunner {
    @Value(value="${spring.datasource.dynamic.primary}")
    public String primary;
    @Autowired
    javax.sql.DataSource dataSource;
    @Autowired
    DBPool dbPool;
    private Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    @Autowired
    private DataSourceService dataSourceService;

    public void run(ApplicationArguments args) {
        List list = DataSourceWrapper.INSTANCE.toDTO(((LambdaQueryChainWrapper)this.dataSourceService.lambdaQuery().eq(DataSource::isEnable, (Object)true)).list());
        for (DataSourceDTO dataLink : list) {
            try {
                this.dbPool.addDs(dataLink);
            }
            catch (Exception e) {
                this.logger.error("\u52a0\u8f7d\u6570\u636e\u5e93\u3010" + dataLink.getPollName() + "\u3011\u8fde\u63a5\u5931\u8d25");
            }
        }
        this.logger.debug("\u591a\u6570\u636e\u63d2\u4ef6\u52a0\u8f7d\u5b8c\u6210!");
    }
}

