/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datalink.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.database.DataSourceConfig;
import com.jeeplus.database.datalink.domain.DataSource;
import com.jeeplus.database.datalink.mapper.DataSourceMapper;
import com.jeeplus.sys.utils.DictUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;

@Service
@Transactional
public class DataSourceService
extends ServiceImpl<DataSourceMapper, DataSource> {
    @Autowired
    private DataSourceConfig dataSourceConfig;

    public String toUrl(String type, String host, String port, String dbName) {
        String template = DictUtils.getDictValue((String)type, (String)"db_jdbc_url", (String)"mysql");
        if (template != null) {
            template = HtmlUtils.htmlUnescape((String)template);
            return template.replace("${host}", host).replace("${port}", port + "").replace("${db}", dbName);
        }
        return null;
    }

    public String getDriver(String type) {
        return DictUtils.getDictValue((String)type, (String)"db_driver", (String)"mysql");
    }

    public DataSource getById(String id) {
        if (StringUtils.isBlank((String)id) || this.dataSourceConfig.primary.equals(id)) {
            return this.createPrimaryDataSource();
        }
        return (DataSource)((Object)super.getById((Serializable)((Object)id)));
    }

    public DataSource getByEnName(String enName) {
        if (StrUtil.isBlank((CharSequence)enName) || this.dataSourceConfig.primary.equals(enName)) {
            return this.createPrimaryDataSource();
        }
        return (DataSource)((Object)((LambdaQueryChainWrapper)super.lambdaQuery().eq(DataSource::getEnName, (Object)enName)).one());
    }

    private DataSource createPrimaryDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setId(this.dataSourceConfig.primary);
        dataSource.setEnName(this.dataSourceConfig.primary);
        dataSource.setName("\u672c\u5730\u6570\u636e\u5e93");
        return dataSource;
    }
}

