/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datamodel.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datamodel.domain.DataMeta;
import com.jeeplus.database.datamodel.domain.DataParam;
import com.jeeplus.database.datamodel.domain.DataSet;
import com.jeeplus.database.datamodel.mapper.DataSetMapper;
import com.jeeplus.database.datamodel.service.DataMetaService;
import com.jeeplus.database.datamodel.service.DataParamService;
import com.jeeplus.database.datamodel.service.dto.DataMetaDTO;
import com.jeeplus.database.datamodel.service.dto.DataParamDTO;
import com.jeeplus.database.datamodel.service.dto.DataSetDTO;
import com.jeeplus.database.datamodel.service.mapstruct.DataMetaWrapper;
import com.jeeplus.database.datamodel.service.mapstruct.DataParamWrapper;
import com.jeeplus.database.datamodel.service.mapstruct.DataSetWrapper;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataSetService
extends ServiceImpl<DataSetMapper, DataSet> {
    @Autowired
    private DataParamService dataParamService;
    @Autowired
    private DataMetaService dataMetaService;

    public DataSetDTO detail(String id) {
        DataSetDTO dataSetDTO = ((DataSetMapper)this.baseMapper).get(id);
        if (dataSetDTO == null) {
            return null;
        }
        dataSetDTO.setColumnList(DataMetaWrapper.INSTANCE.toDTO(((LambdaQueryChainWrapper)this.dataMetaService.lambdaQuery().eq(DataMeta::getDataSetId, (Object)id)).list()));
        dataSetDTO.setParams(DataParamWrapper.INSTANCE.toDTO(((LambdaQueryChainWrapper)this.dataParamService.lambdaQuery().eq(DataParam::getDataSetId, (Object)id)).list()));
        return dataSetDTO;
    }

    public IPage<DataSetDTO> findPage(Page<DataSetDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((DataSetMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public void saveOrUpdate(DataSetDTO dataSetDTO) {
        DataSet dataSet = DataSetWrapper.INSTANCE.toEntity(dataSetDTO);
        if (StrUtil.isNotBlank((CharSequence)dataSet.getId())) {
            ((LambdaUpdateChainWrapper)this.dataMetaService.lambdaUpdate().eq(DataMeta::getDataSetId, (Object)dataSet.getId())).remove();
            ((LambdaUpdateChainWrapper)this.dataParamService.lambdaUpdate().eq(DataParam::getDataSetId, (Object)dataSet.getId())).remove();
        }
        super.saveOrUpdate((Object)dataSet);
        for (DataMetaDTO dataMetaDTO : dataSetDTO.getColumnList()) {
            DataMeta dataMeta = DataMetaWrapper.INSTANCE.toEntity(dataMetaDTO);
            dataMeta.setDataSetId(dataSet.getId());
            this.dataMetaService.saveOrUpdate((Object)dataMeta);
        }
        for (DataParamDTO paramsDTO : dataSetDTO.getParams()) {
            DataParam dataParam = DataParamWrapper.INSTANCE.toEntity(paramsDTO);
            dataParam.setDataSetId(dataSet.getId());
            this.dataParamService.saveOrUpdate((Object)dataParam);
        }
    }

    public void delete(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.dataParamService.lambdaUpdate().eq(DataParam::getDataSetId, (Object)id)).remove();
        ((LambdaUpdateChainWrapper)this.dataMetaService.lambdaUpdate().eq(DataMeta::getDataSetId, (Object)id)).remove();
    }

    public List<Map<String, Object>> queryForListById(String id, HttpServletRequest request) throws Exception {
        Map<String, String> paramsMap = this.dataParamService.getParamsForMap(id);
        if (request != null) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String param = ((String)names.nextElement()).toString();
                paramsMap.put(param, request.getParameter(param));
            }
        }
        String sql = this.mergeSql(((DataSetMapper)this.baseMapper).get(id).getSqlCmd(), paramsMap);
        return DBPool.getInstance().getJdbcTemplateByDsId(((DataSetMapper)this.baseMapper).get(id).getDataSource().getId()).queryForList(sql);
    }

    public String mergeSql(String sql, String[] field, String[] value) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                paramsMap.put(field[i], value[i]);
            }
        }
        return this.mergeSql(sql, paramsMap);
    }

    public String mergeSql(String sql, Map<String, String> paramsMap) {
        sql = HtmlUtil.unescape((String)sql);
        for (String key : paramsMap.keySet()) {
            sql = sql.replace("{#" + key + "#}", paramsMap.get(key));
        }
        return sql;
    }

    public JSONArray toJSON(List<Map<String, Object>> list) {
        JSONArray data = new JSONArray();
        for (Map<String, Object> map : list) {
            JSONObject obj = new JSONObject();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value != null) {
                    obj.element(key, (Object)value.toString());
                    continue;
                }
                obj.element(key, (Object)"");
            }
            data.add((Object)obj);
        }
        return data;
    }

    public String toXML(List<Map<String, Object>> data) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<list>\n");
        for (Map<String, Object> map : data) {
            xml.append("  <data>\n");
            for (String key : map.keySet()) {
                Object val = map.get(key);
                xml.append("    <prop key=\"" + key + "\">\n      <![CDATA[" + val + "]]>\n    </prop>\n");
            }
            xml.append("  </data>\n");
        }
        xml.append("</list>\n");
        return xml.toString();
    }

    public String toHTML(List<Map<String, Object>> data) {
        StringBuffer html = new StringBuffer("<table class='table table-bordered table-condensed'>");
        StringBuffer head = new StringBuffer("<thead><tr>");
        StringBuffer body = new StringBuffer("<tbody><tr>");
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> map = data.get(i);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (i == 0) {
                    head.append("<th>").append(entry.getKey()).append("</th>");
                }
                body.append("<td>").append(entry.getValue()).append("</td>");
            }
            body.append("</tr><tr>");
        }
        head.append("</tr></thead>");
        body.append("</tr></tbody>");
        html.append(head).append(body).append("</table>");
        return html.toString();
    }
}

