/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.security.jwt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    public static final String TOKEN = "token";

    public static boolean validateToken(String token, String accessToken) {
        String userName = TokenProvider.getLoginName(accessToken);
        String password = UserUtils.getByLoginName(userName).getPassword();
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)password);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", userName).build();
            verifier.verify(accessToken);
            return true;
        }
        catch (TokenExpiredException e) {
            String newAccessToken = TokenProvider.createAccessToken(userName, password);
            RedisUtils.getInstance().set("user:cache:token:" + userName + ":" + token, (Object)newAccessToken);
            RedisUtils.getInstance().expire("user:cache:token:" + userName + ":" + token, JeePlusProperties.newInstance().getEXPIRE_TIME());
            return true;
        }
        catch (Exception e) {
            log.info("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
            return false;
        }
    }

    public static String getLoginName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createAccessToken(String username, String password) {
        Date date = new Date(System.currentTimeMillis() + JeePlusProperties.newInstance().getEXPIRE_TIME() * 1000L);
        Algorithm algorithm = Algorithm.HMAC256((String)password);
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static Authentication getAuthentication(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        String username = jwt.getClaim("username").asString();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        Set<String> permissions = UserUtils.getPermissionsByLoginName(username);
        for (String permission : permissions) {
            authorities.add(new SimpleGrantedAuthority(permission));
        }
        User principal = new User(username, "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public static String resolveToken(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        String token0 = httpServletRequest.getParameter(TOKEN);
        String token1 = httpServletRequest.getHeader(TOKEN);
        Cookie token2 = ServletUtil.getCookie((HttpServletRequest)httpServletRequest, (String)TOKEN);
        if (StrUtil.isNotBlank((CharSequence)token0)) {
            return token0;
        }
        if (StrUtil.isNotBlank((CharSequence)token1)) {
            return token1;
        }
        if (token2 != null && StrUtil.isNotBlank((CharSequence)token2.getValue())) {
            return token2.getValue();
        }
        return null;
    }
}

