/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.sys.domain.Menu;
import com.jeeplus.sys.service.MenuService;
import com.jeeplus.sys.service.dto.MenuDTO;
import com.jeeplus.sys.service.mapstruct.MenuWrapper;
import com.jeeplus.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu"})
public class MenuController {
    @Autowired
    private MenuService menuService;
    @Autowired
    private MenuWrapper menuWrapper;

    @ApiLog(value="\u67e5\u8be2\u83dc\u5355")
    @PreAuthorize(value="hasAnyAuthority('sys:menu:view','sys:menu:add','sys:menu:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(@RequestParam String id) {
        MenuDTO menuDTO = (MenuDTO)this.menuWrapper.toDTO(this.menuService.getById(id));
        String parentId = menuDTO.getParentId();
        MenuDTO parentDTO = (MenuDTO)this.menuWrapper.toDTO(this.menuService.getById(parentId));
        menuDTO.setParent(parentDTO);
        return ResponseEntity.ok((Object)menuDTO);
    }

    @DemoMode
    @ApiLog(value="\u4fdd\u5b58\u83dc\u5355")
    @PreAuthorize(value="hasAnyAuthority('sys:menu:add','sys:menu:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody MenuDTO menuDTO) {
        Menu menu;
        if (!UserUtils.getCurrentUserDTO().isAdmin()) {
            return ResponseEntity.badRequest().body((Object)"\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u6dfb\u52a0\u6216\u4fee\u6539\u6570\u636e\uff01");
        }
        if (StrUtil.isBlank((CharSequence)menuDTO.getId())) {
            ArrayList list = Lists.newArrayList();
            List<MenuDTO> sourceList = UserUtils.getMenuDTOList();
            MenuDTO.sortList(list, sourceList, menuDTO.getParentId(), false);
            if (list.size() > 0) {
                MenuDTO mDTO = (MenuDTO)list.get(list.size() - 1);
                Integer sort = mDTO.getSort() == null ? 30 : mDTO.getSort() + 30;
                menuDTO.setSort(sort);
            }
            menu = (Menu)this.menuWrapper.toEntity(menuDTO);
        } else {
            Menu oldMenu = this.menuService.getById(menuDTO.getId());
            Menu newMenu = (Menu)this.menuWrapper.toEntity(menuDTO);
            BeanUtil.copyProperties((Object)newMenu, (Object)oldMenu, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            menu = oldMenu;
        }
        this.menuService.saveOrUpdate(menu);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @DemoMode
    @ApiLog(value="\u5220\u9664\u83dc\u5355")
    @PreAuthorize(value="hasAuthority('sys:menu:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.menuService.deleteById(id);
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f!");
    }

    @ApiLog(value="\u8bfb\u53d6\u83dc\u5355\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity treeData(@RequestParam(required=false) String extId, @RequestParam(required=false, defaultValue="0") String isShowHide) {
        List<MenuDTO> list = UserUtils.getMenuDTOList();
        List<MenuDTO> rootTree = this.menuService.getTreeMenu(list, extId, isShowHide);
        return ResponseEntity.ok(rootTree);
    }
}

