/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.notify.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.notify.domain.Notify;
import com.jeeplus.notify.domain.NotifyRecord;
import com.jeeplus.notify.mapper.NotifyMapper;
import com.jeeplus.notify.service.NotifyRecordService;
import com.jeeplus.notify.service.dto.NotifyDTO;
import com.jeeplus.notify.service.dto.NotifyRecordDTO;
import com.jeeplus.notify.service.mapstruct.NotifyRecordWrapper;
import com.jeeplus.notify.service.mapstruct.NotifyWrapper;
import com.jeeplus.sys.utils.UserUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NotifyService
extends ServiceImpl<NotifyMapper, Notify> {
    @Autowired
    private NotifyRecordService notifyRecordService;

    public NotifyDTO getById(String id) {
        return ((NotifyMapper)this.baseMapper).getById(id);
    }

    public IPage<NotifyDTO> findPage(Page<NotifyDTO> page, String currentUserId, boolean isSelf, String readFlag, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((NotifyMapper)this.baseMapper).findList(page, currentUserId, isSelf, readFlag, queryWrapper);
    }

    public NotifyDTO getDetail(String id) {
        NotifyDTO notifyDTO = ((NotifyMapper)this.baseMapper).getById(id);
        List<NotifyRecordDTO> notifyRecordList = this.notifyRecordService.findListByNotifyId(id);
        notifyDTO.setNotifyRecordDTOList(notifyRecordList);
        return notifyDTO;
    }

    public Long findCount(String currentUserId, boolean isSelf, String readFlag) {
        return ((NotifyMapper)this.baseMapper).findCount(currentUserId, isSelf, readFlag);
    }

    public boolean saveOrUpdate(NotifyDTO notifyDTO) {
        Notify notify = (Notify)((Object)NotifyWrapper.INSTANCE.toEntity((Object)notifyDTO));
        super.saveOrUpdate((Object)notify);
        notifyDTO.setId(notify.getId());
        ((LambdaUpdateChainWrapper)this.notifyRecordService.lambdaUpdate().eq(NotifyRecord::getNotifyId, (Object)notify.getId())).remove();
        this.notifyRecordService.saveBatch(NotifyRecordWrapper.INSTANCE.toEntity(notifyDTO.getNotifyRecordDTOList()));
        return true;
    }

    public void updateReadFlag(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.notifyRecordService.lambdaUpdate().eq(NotifyRecord::getNotifyId, (Object)id)).eq(NotifyRecord::getUserId, (Object)UserUtils.getCurrentUserDTO().getId())).ne(NotifyRecord::getReadFlag, (Object)"1")).set(NotifyRecord::getReadDate, (Object)new Date())).set(NotifyRecord::getReadFlag, (Object)"1")).update();
    }
}

