/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.parkmanagement.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.buildinginfo.service.BuildingManagementService;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.excel.EasyExcelUtils;
import com.jeeplus.core.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.parkmanagement.domain.ParkManagement;
import com.jeeplus.parkmanagement.service.ParkManagementService;
import com.jeeplus.parkmanagement.service.dto.ParkManagementDTO;
import com.jeeplus.parkmanagement.service.mapstruct.ParkManagementWrapper;
import com.jeeplus.sys.domain.Office;
import com.jeeplus.sys.domain.User;
import com.jeeplus.sys.service.OfficeService;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u56ed\u533a\u4fe1\u606f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/parkmanagement/parkManagement"})
public class ParkManagementController {
    @Autowired
    private ParkManagementService parkManagementService;
    @Autowired
    private BuildingManagementService buildingManagementService;
    @Autowired
    private ParkManagementWrapper parkManagementWrapper;
    @Autowired
    private UserService userService;
    @Autowired
    private OfficeService officeService;

    @ApiLog(value="\u67e5\u8be2\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('parkmanagement:parkManagement:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<ParkManagement>> list(ParkManagementDTO parkManagementDTO, Page<ParkManagement> page) throws Exception {
        String officeId;
        String qyid;
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)parkManagementDTO), ParkManagementDTO.class);
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        String[] roleIds = userDTO.getRoleIds().split(",");
        if (Arrays.asList(roleIds).contains("1861216543360913410") && (qyid = this.buildingManagementService.findQyidByOfficeid(officeId = userDTO.getOfficeDTO().getId())) != null && !qyid.equals("")) {
            queryWrapper.eq((Object)"id", (Object)qyid);
        }
        IPage result = this.parkManagementService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u67e5\u8be2\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u5217\u8868\u6570\u636e")
    @GetMapping(value={"list1"})
    public ResponseEntity<IPage<ParkManagement>> list1(ParkManagementDTO parkManagementDTO, Page<ParkManagement> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)parkManagementDTO), ParkManagementDTO.class);
        IPage result = this.parkManagementService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('parkmanagement:parkManagement:view','parkmanagement:parkManagement:add','parkmanagement:parkManagement:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<ParkManagementDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.parkManagementWrapper.toDTO(this.parkManagementService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u56ed\u533a\u4fe1\u606f\u7ba1\u7406")
    @ApiOperation(value="\u4fdd\u5b58\u56ed\u533a\u4fe1\u606f\u7ba1\u7406")
    @PreAuthorize(value="hasAnyAuthority('parkmanagement:parkManagement:add','parkmanagement:parkManagement:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody ParkManagementDTO parkManagementDTO) {
        String officeid = UUID.randomUUID().toString().replace("-", "");
        String buildid = UUID.randomUUID().toString().replace("-", "");
        String oldLoginname = "";
        String oldParkManagementName = "";
        if (parkManagementDTO.getId() != null && !parkManagementDTO.getId().equals("")) {
            oldLoginname = ((ParkManagement)((Object)this.parkManagementService.getById((Serializable)((Object)parkManagementDTO.getId())))).getPropertyPhone();
            oldParkManagementName = ((ParkManagement)((Object)this.parkManagementService.getById((Serializable)((Object)parkManagementDTO.getId())))).getParkName();
        }
        if (null == parkManagementDTO.getId() || parkManagementDTO.getId().isEmpty()) {
            QueryWrapper queryWrapper3 = new QueryWrapper();
            ((QueryWrapper)queryWrapper3.eq((Object)"name", (Object)parkManagementDTO.getPropertyPhone())).eq((Object)"del_flag", (Object)"0");
            User userone = (User)this.userService.getOne((Wrapper)queryWrapper3);
            if (null != userone) {
                return ResponseEntity.ok((Object)"\u8be5\u7535\u8bdd\u5df2\u5b58\u5728\uff01");
            }
            parkManagementDTO.setPlace("320900/320903/320903004");
            parkManagementDTO.setPlaceSelectType3("320900");
            parkManagementDTO.setPlaceSelectType4("320903");
            parkManagementDTO.setPlaceSelectType5("320903004");
            Office office = new Office();
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"name", (Object)parkManagementDTO.getParkName())).eq((Object)"type", (Object)"2")).eq((Object)"del_flag", (Object)"0");
            Office one = (Office)this.officeService.getOne((Wrapper)queryWrapper);
            if (null != one) {
                return ResponseEntity.badRequest().body((Object)"\u5df2\u5b58\u5728\uff01");
            }
            UserDTO cuserDTO = UserUtils.getCurrentUserDTO();
            this.officeService.insertOffice(officeid, "2", "2", "1", parkManagementDTO.getParkName(), "1852255263109984258", "0,1852255263109984258,", cuserDTO.getId());
            ParkManagement p = (ParkManagement)((Object)this.parkManagementWrapper.toEntity((Object)parkManagementDTO));
            p.setId(buildid);
            UserDTO userDTO = UserUtils.getCurrentUserDTO();
            p.setCreateBy(userDTO.getId());
            p.setCreateDate(new Date());
            p.setUpdateBy(userDTO.getId());
            p.setUpdateDate(new Date());
            p.setDelFlag(0);
            this.parkManagementService.insertParkManagement(p);
            this.officeService.saveOfficeMiddleTable(officeid, buildid, "", "1");
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"name", (Object)oldParkManagementName)).eq((Object)"del_flag", (Object)"0");
            Office one = (Office)this.officeService.getOne((Wrapper)queryWrapper);
            one.setName(parkManagementDTO.getParkName());
            this.officeService.saveOrUpdate((TreeEntity)one);
            this.parkManagementService.saveOrUpdate(this.parkManagementWrapper.toEntity((Object)parkManagementDTO));
        }
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u56ed\u533a\u4fe1\u606f\u7ba1\u7406")
    @ApiOperation(value="\u5220\u9664\u56ed\u533a\u4fe1\u606f\u7ba1\u7406")
    @PreAuthorize(value="hasAuthority('parkmanagement:parkManagement:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.parkManagementService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('parkmanagement:parkManagement:export')")
    @GetMapping(value={"export"})
    public void exportFile(ParkManagementDTO parkManagementDTO, Page<ParkManagement> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)parkManagementDTO), ParkManagementDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.parkManagementService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.parkManagementService, (EntityWrapper)this.parkManagementWrapper).exportExcel(result, options.getSheetName(), ParkManagementDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('parkmanagement:parkManagement:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.parkManagementService, (EntityWrapper)this.parkManagementWrapper).importExcel(file, ParkManagementDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('parkmanagement:parkManagement:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.parkManagementService, (EntityWrapper)this.parkManagementWrapper).exportExcel((List)list, "\u56ed\u533a\u4fe1\u606f\u7ba1\u7406\u6570\u636e", ParkManagementDTO.class, fileName, null, response);
    }
}

