/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.domain.TreeMapper;
import com.jeeplus.core.service.dto.TreeDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class TreeService<D extends TreeMapper<T>, T extends TreeEntity<T>>
extends ServiceImpl<D, T> {
    private static final Logger log = LoggerFactory.getLogger(TreeService.class);

    public boolean saveOrUpdate(T entity) {
        TreeEntity parent = TreeDTO.getRootId().equals(((TreeEntity)entity).getParentId()) || StrUtil.isBlank((CharSequence)((TreeEntity)entity).getParentId()) ? null : (TreeEntity)super.getById((Serializable)((Object)((TreeEntity)entity).getParentId()));
        if (parent == null) {
            try {
                parent = (TreeEntity)this.entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                parent.setId(TreeDTO.getRootId());
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
            }
            ((TreeEntity)entity).setParentId(parent.getId());
            parent.setParentIds("");
        }
        String oldParentIds = StrUtil.isNotBlank((CharSequence)((BaseEntity)entity).getId()) ? ((TreeEntity)super.getById((Serializable)((Object)((BaseEntity)entity).getId()))).getParentIds() : null;
        ((TreeEntity)entity).setParentIds(parent.getParentIds() + parent.getId() + ",");
        super.saveOrUpdate(entity);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper(entity.getClass()).like(TreeEntity::getParentIds, (Object)("," + ((BaseEntity)entity).getId() + ","));
        List list = super.list((Wrapper)queryWrapper);
        for (TreeEntity e : list) {
            if (e.getParentIds() == null || oldParentIds == null) continue;
            e.setParentIds(e.getParentIds().replace(oldParentIds, ((TreeEntity)entity).getParentIds()));
            super.updateById((Object)e);
        }
        return true;
    }

    public List<T> getChildren(T parent) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper(parent.getClass()).eq(TreeEntity::getParentId, (Object)((BaseEntity)parent).getId());
        return super.list((Wrapper)queryWrapper);
    }

    public boolean removeWithChildrenById(String id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(this.entityClass).like(StrUtil.isNotBlank((CharSequence)id), TreeEntity::getParentIds, (Object)("," + id + ","))).or()).eq(StrUtil.isNotBlank((CharSequence)id), BaseEntity::getId, (Object)id);
        return super.remove((Wrapper)queryWrapper);
    }

    public void removeWithChildrenByIds(List<String> idList) {
        idList.stream().forEach(this::removeWithChildrenById);
    }

    public List<T> treeData() {
        return this.treeData(null);
    }

    public List<T> treeData(String extId) {
        List allList = super.list((Wrapper)new LambdaQueryWrapper(this.entityClass).orderByAsc(TreeEntity::getSort));
        try {
            TreeEntity root = (TreeEntity)this.entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            root.setId(TreeDTO.getRootId());
            List<TreeEntity> rootTree = this.formatListToTree(root, allList, extId);
            return rootTree;
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            return null;
        }
    }

    public List<T> formatListToTree(T root, List<T> allList, String extId) {
        String rootId = ((BaseEntity)root).getId();
        ArrayList trees = Lists.newArrayList();
        HashMap treeMap = Maps.newHashMap();
        for (TreeEntity entity : allList) {
            List entities = (List)treeMap.get(entity.getParentId());
            if (entities == null) {
                entities = Lists.newLinkedList();
            }
            if (!StrUtil.isBlank((CharSequence)extId) && (extId.equals(entity.getId()) || entity.getParentIds().indexOf("," + extId + ",") != -1)) continue;
            entities.add(entity);
            treeMap.put(entity.getParentId(), entities);
        }
        if (treeMap.get(rootId) == null || ((List)treeMap.get(rootId)).isEmpty()) {
            return trees;
        }
        List children = (List)treeMap.get(rootId);
        for (TreeEntity parent : children) {
            this.formatFillChildren(parent, treeMap);
            trees.add(parent);
        }
        if (StrUtil.equals((CharSequence)rootId, (CharSequence)TreeDTO.getRootId())) {
            return children;
        }
        ((TreeEntity)root).setChildren(trees);
        return Lists.newArrayList((Object[])new TreeEntity[]{root});
    }

    private void formatFillChildren(T parent, Map<String, List<T>> treeMap) {
        List<T> children = treeMap.get(((BaseEntity)parent).getId());
        ((TreeEntity)parent).setChildren(children);
        if (children != null && !children.isEmpty()) {
            for (TreeEntity child : children) {
                this.formatFillChildren(child, treeMap);
            }
        }
    }
}

