/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.common.utils.RequestUtils;
import com.jeeplus.sys.domain.SysConfig;
import com.jeeplus.sys.domain.User;
import com.jeeplus.sys.mapper.UserMapper;
import com.jeeplus.sys.service.SysConfigService;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.service.mapstruct.UserWrapper;
import com.jeeplus.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserService
extends ServiceImpl<UserMapper, User> {
    @Autowired
    private UserWrapper userWrapper;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SysConfigService sysConfigService;

    public boolean isEnableLogin(String loginName) {
        SysConfig sysConfig = this.sysConfigService.getById("1");
        if (sysConfig.getMultiAccountLogin().equals("0")) {
            if (sysConfig.getSingleLoginType().equals("1")) {
                Set keys = RedisUtils.getInstance().keys("user:cache:token:" + loginName + "*");
                keys.forEach(key -> {
                    String token = RedisUtils.getInstance().get(key).toString();
                    RedisUtils.getInstance().set("user:cache:token:" + loginName + ":" + token, (Object)"kickOut");
                });
            } else if (this.redisUtils.keys("user:cache:token:" + loginName + "*").size() > 0) {
                return false;
            }
        }
        return true;
    }

    public UserDTO get(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"a.id", (Object)id);
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((UserMapper)this.baseMapper).get(queryWrapper);
    }

    @Cacheable(cacheNames={"user:cache:loginName"}, key="#loginName")
    public UserDTO getUserByLoginName(String loginName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"a.login_name", (Object)loginName);
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((UserMapper)this.baseMapper).get(queryWrapper);
    }

    public IPage<UserDTO> findPage(Page<UserDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((UserMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public IPage<UserDTO> findPageByRole(Page<UserDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((UserMapper)this.baseMapper).findListByRole(page, queryWrapper);
    }

    public List<UserDTO> findListByRoleId(String roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        queryWrapper.eq((Object)"r.id", (Object)roleId);
        Page page = new Page();
        page.setSize(-1L);
        return ((UserMapper)this.baseMapper).findListByRole((Page<UserDTO>)page, queryWrapper).getRecords();
    }

    public List<UserDTO> findListByPostId(String postId) {
        return ((UserMapper)this.baseMapper).findListByPostId(postId);
    }

    public void saveOrUpdate(UserDTO userDTO) {
        User user = this.userWrapper.toEntity(userDTO);
        super.saveOrUpdate((Object)user);
        if (StrUtil.isBlank((CharSequence)userDTO.getId())) {
            userDTO.setId(user.getId());
        }
        ((UserMapper)this.baseMapper).deleteUserRole(userDTO.getId());
        if (userDTO.getRoleDTOList() == null) {
            throw new RuntimeException(userDTO.getLoginName() + "\u6ca1\u6709\u8bbe\u7f6e\u89d2\u8272\uff01");
        }
        userDTO.getRoleDTOList().forEach(roleDTO -> ((UserMapper)this.baseMapper).insertUserRole(userDTO.getId(), roleDTO.getId()));
        ((UserMapper)this.baseMapper).deleteUserPost(userDTO.getId());
        if (userDTO.getPostDTOList() != null) {
            userDTO.getPostDTOList().forEach(postDTO -> ((UserMapper)this.baseMapper).insertUserPost(userDTO.getId(), postDTO.getId()));
        }
        UserUtils.deleteCache(userDTO);
    }

    public void deleteUser(UserDTO userDTO) {
        ((UserMapper)this.baseMapper).deleteUserRole(userDTO.getId());
        ((UserMapper)this.baseMapper).deleteUserPost(userDTO.getId());
        super.removeById((Serializable)((Object)userDTO.getId()));
        UserUtils.deleteCache(userDTO);
    }

    public void updateUserLoginInfo(UserDTO userDTO) {
        User user = new User(userDTO.getId());
        HttpServletRequest request = RequestUtils.getRequest();
        if (request != null) {
            user.setLoginIp(request.getRemoteHost());
        }
        user.setLoginDate(new Date());
        super.updateById((Object)user);
    }

    public UserDTO getUserDTOByName(String name) {
        return UserWrapper.INSTANCE.toDTO((User)((LambdaQueryChainWrapper)this.lambdaQuery().eq(User::getName, (Object)name)).one());
    }
}

