/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datamodel.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datamodel.domain.DataMeta;
import com.jeeplus.database.datamodel.domain.DataParam;
import com.jeeplus.database.datamodel.domain.DataSet;
import com.jeeplus.database.datamodel.service.DataMetaService;
import com.jeeplus.database.datamodel.service.DataParamService;
import com.jeeplus.database.datamodel.service.DataSetService;
import com.jeeplus.database.datamodel.service.dto.DataSetDTO;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/database/datamodel/dataSet"})
public class DataSetController {
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private DataMetaService dataMetaService;
    @Autowired
    private DataParamService dataParamService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @PreAuthorize(value="hasAuthority('database:datamodel:dataSet:list')")
    @GetMapping(value={"list"})
    public ResponseEntity data(DataSetDTO dataSetDTO, Page<DataSetDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)dataSetDTO), DataSetDTO.class);
        IPage<DataSetDTO> result = this.dataSetService.findPage(page, queryWrapper);
        return ResponseEntity.ok(result);
    }

    @PreAuthorize(value="hasAnyAuthority('database:datamodel:dataSet:view','database:datamodel:dataSet:add','database:datamodel:dataSet:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id) {
        DataSetDTO dataSetDTO = this.dataSetService.detail(id);
        return ResponseEntity.ok((Object)((Object)dataSetDTO));
    }

    @PreAuthorize(value="hasAnyAuthority('database:datamodel:dataSet:add','database:datamodel:dataSet:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody @Valid DataSetDTO dataSetDTO) {
        this.dataSetService.saveOrUpdate(dataSetDTO);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6570\u636e\u6a21\u578b\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('database:datamodel:dataSet:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids") String ids) {
        String[] idArray = ids.split(",");
        StringBuffer msg = new StringBuffer();
        for (String id : idArray) {
            List list = this.jdbcTemplate.queryForList("select name from plugin_echarts where data_set_id = '" + id + "'");
            if (list.size() > 0) {
                String name = "";
                for (Map map : list) {
                    name = name + " [" + map.get("name").toString() + "]";
                }
                msg.append("\u6570\u636e\u6a21\u578b [" + ((DataSet)((Object)this.dataSetService.getById((Serializable)((Object)id)))).getName() + "] \u5df2\u88ab\u56fe\u8868" + name + " \u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002\u8bf7\u5148\u5220\u9664\u56fe\u8868\uff0c\u518d\u5220\u9664\u8be5\u6570\u636e\u6a21\u578b\u3002");
                continue;
            }
            ((LambdaUpdateChainWrapper)this.dataMetaService.lambdaUpdate().eq(DataMeta::getDataSetId, (Object)id)).remove();
            ((LambdaUpdateChainWrapper)this.dataParamService.lambdaUpdate().eq(DataParam::getDataSetId, (Object)id)).remove();
            msg.append("\u5220\u9664\u6570\u636e\u6a21\u578b [" + ((DataSet)((Object)this.dataSetService.getById((Serializable)((Object)id)))).getName() + "] \u6210\u529f\u3002");
            this.dataSetService.delete(id);
        }
        return ResponseEntity.ok((Object)msg.toString());
    }

    @GetMapping(value={"getMeta"})
    public ResponseEntity query(@RequestParam(value="dataSourceId", required=false) String dataSourceId, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="field[]", required=false) String[] field, @RequestParam(value="defaultValue[]", required=false) String[] defaultValue) throws IOException, SQLException {
        ArrayList columnList = new ArrayList();
        JdbcTemplate jdbcTemplate = DBPool.getInstance().getJdbcTemplateByDsId(dataSourceId);
        if (jdbcTemplate == null) {
            return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u5e93\u94fe\u63a5\u4e0d\u5b58\u5728!");
        }
        sql = this.dataSetService.mergeSql(sql, field, defaultValue);
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sql);
        int count = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= count; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", rs.getMetaData().getColumnLabel(i));
            map.put("type", rs.getMetaData().getColumnTypeName(i));
            map.put("label", rs.getMetaData().getColumnLabel(i));
            columnList.add(map);
        }
        return ResponseEntity.ok(columnList);
    }

    @GetMapping(value={"/exec"})
    public ResponseEntity exec(@RequestParam(value="dataSourceId", required=false) String dataSourceId, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="field[]", required=false) String[] field, @RequestParam(value="defaultValue[]", required=false) String[] defaultValue) {
        try {
            JdbcTemplate jdbcTemplate = DBPool.getInstance().getJdbcTemplateByDsId(dataSourceId);
            if (jdbcTemplate == null) {
                return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u5e93\u94fe\u63a5\u4e0d\u5b58\u5728!");
            }
            if (sql.contains("delete") || sql.contains("update")) {
                return ResponseEntity.badRequest().body((Object)"\u53ea\u5141\u8bb8\u67e5\u8be2\u64cd\u4f5c!");
            }
            sql = this.dataSetService.mergeSql(sql, field, defaultValue);
            List list = jdbcTemplate.queryForList(sql);
            JSONArray data = this.dataSetService.toJSON(list);
            return ResponseUtil.newInstance().add("html", (Object)this.dataSetService.toHTML((List<Map<String, Object>>)data)).add("json", (Object)list).add("xml", (Object)this.dataSetService.toXML((List<Map<String, Object>>)data)).ok();
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)e.getCause().getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getData/{id}/{type}"})
    public ResponseEntity getData(@PathVariable(value="id") String id, @PathVariable(value="type") String type, HttpServletRequest request) {
        Enumeration names = request.getParameterNames();
        DataSet dataSet = (DataSet)((Object)this.dataSetService.getById((Serializable)((Object)id)));
        try {
            JdbcTemplate jdbcTemplate = DBPool.getInstance().getJdbcTemplateByEnName(dataSet.getDataSourceId());
            if (jdbcTemplate == null) {
                return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u5e93\u94fe\u63a5\u4e0d\u5b58\u5728!");
            }
            Map<String, String> paramsMap = this.dataParamService.getParamsForMap(id);
            while (names.hasMoreElements()) {
                String param = (String)names.nextElement();
                paramsMap.put(param, request.getParameter(param));
            }
            String sql = this.dataSetService.mergeSql(dataSet.getSqlCmd(), paramsMap);
            List list = jdbcTemplate.queryForList(sql);
            JSONArray data = this.dataSetService.toJSON(list);
            if ("html".equals(type)) {
                return ResponseEntity.ok((Object)this.dataSetService.toHTML((List<Map<String, Object>>)data));
            }
            if ("xml".equals(type)) {
                return ResponseEntity.ok((Object)this.dataSetService.toXML((List<Map<String, Object>>)data));
            }
            return ResponseEntity.ok((Object)list);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)e.getCause().getLocalizedMessage());
        }
    }
}

