/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.utils;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.jeeplus.common.utils.FileUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.sys.model.FileData;
import com.jeeplus.sys.utils.UserUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FileKit {
    public static List<FileData> getFileList(File[] files) {
        ArrayList fileDataList = Lists.newArrayList();
        if (files != null) {
            for (File file : files) {
                FileData fileData = new FileData();
                if (file.isDirectory()) {
                    fileData.setId(file.getName());
                    fileData.setType("folder");
                    fileData.setOpen(true);
                    fileData.setValue(file.getName());
                    fileData.setData(FileKit.getFileList(file.listFiles()));
                } else {
                    fileData.setId(file.getName());
                    fileData.setType("file");
                    fileData.setSize(String.valueOf(file.getTotalSpace()));
                    fileData.setValue(file.getName());
                }
                fileDataList.add(fileData);
            }
        }
        return fileDataList;
    }

    public static String getFileType(String fileName) {
        String suffix;
        String type = "file";
        switch (suffix = StrUtil.subAfter((CharSequence)fileName, (CharSequence)".", (boolean)true)) {
            case "htm": 
            case "html": 
            case "css": 
            case "less": 
            case "asp": 
            case "php": 
            case "jsp": 
            case "js": 
            case "java": 
            case "class": 
            case "c": 
            case "sql": {
                type = "code";
                break;
            }
            case "doc": {
                type = "word";
                break;
            }
            case "txt": {
                type = "text";
                break;
            }
            case "wps": {
                type = "word";
                break;
            }
            case "xls": 
            case "xlsx": {
                type = "excel";
                break;
            }
            case "ppt": 
            case "pptx": {
                type = "pp";
                break;
            }
            case "pdf": {
                type = "pdf";
                break;
            }
            case "rar": 
            case "zip": {
                type = "archive";
                break;
            }
            case "exe": {
                type = "fa-windows";
                break;
            }
            case "rmvb": 
            case "wmv": 
            case "asf": 
            case "avi": 
            case "3gp": 
            case "mpg": 
            case "mkv": 
            case "mp4": 
            case "dvd": 
            case "ogm": 
            case "mov": 
            case "mpeg2": 
            case "mpeg4": {
                type = "video";
                break;
            }
            case "mp3": 
            case "ogg": 
            case "wav": 
            case "ape": 
            case "cda": 
            case "au": 
            case "midi": 
            case "mac": 
            case "aac": {
                type = "audio";
                break;
            }
            case "flv": 
            case "swf": 
            case "m4v": 
            case "f4v": {
                type = "flash";
                break;
            }
            case "gif": 
            case "jpeg": 
            case "bmp": 
            case "tif": 
            case "png": 
            case "jpg": 
            case "pcd": 
            case "qti": 
            case "qtf": 
            case "tiff": {
                type = "image";
                break;
            }
            default: {
                type = "file";
            }
        }
        return type;
    }

    private static Long getCreateTime(String fullFileName) {
        Path path = Paths.get(fullFileName, new String[0]);
        BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            BasicFileAttributes attr = basicview.readAttributes();
            Date createDate = new Date(attr.creationTime().toMillis());
            return createDate.getTime() / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            Calendar cal = Calendar.getInstance();
            cal.set(1970, 0, 1, 0, 0, 0);
            return cal.getTime().getTime() / 1000L;
        }
    }

    public static List<FileData> getFileList(String pId, List<File> files) {
        ArrayList fileDataList = Lists.newArrayList();
        if (files != null) {
            for (File file : files) {
                FileData fileData = new FileData();
                if (file.isDirectory()) {
                    fileData.setId(FileKit.transDirToUrl(file.getAbsolutePath()));
                    fileData.setType("folder");
                    fileData.setOpen(true);
                    fileData.setPId(pId);
                    fileData.setDate(FileKit.getCreateTime(file.getAbsolutePath()));
                    fileData.setValue(file.getName());
                    file.listFiles();
                    fileData.setData(FileKit.getFileList(file.getName(), Lists.newArrayList((Object[])file.listFiles())));
                } else {
                    fileData.setId(FileKit.transDirToUrl(file.getAbsolutePath()));
                    fileData.setType(FileKit.getFileType(file.getName()));
                    fileData.setPId(pId);
                    fileData.setSize(String.valueOf(file.length()));
                    fileData.setDate(FileKit.getCreateTime(file.getAbsolutePath()));
                    fileData.setValue(file.getName());
                }
                fileDataList.add(fileData);
            }
        }
        return fileDataList;
    }

    public static String getFileDir(String fileUrl) {
        return (JeePlusProperties.newInstance().getUserfilesBaseDir() + fileUrl).replace("\\", "/");
    }

    public static String transDirToUrl(String dir) {
        return dir.substring(JeePlusProperties.newInstance().getUserfilesBaseDir().length());
    }

    public static String getShareBaseDir() {
        String dir = JeePlusProperties.newInstance().getUserfilesBaseDir() + "/userdir/" + "\u5171\u4eab\u6587\u6863/";
        FileUtils.createDirectory((String)dir);
        return dir;
    }

    public static String getShareBaseUrl() {
        return "/userdir//\u5171\u4eab\u6587\u6863/";
    }

    public static String getMyDocDir() {
        String id = UserUtils.getCurrentUserDTO().getId();
        String dir = JeePlusProperties.newInstance().getUserfilesBaseDir() + "/userdir/" + id + "/\u6211\u7684\u6587\u6863/";
        FileUtils.createDirectory((String)dir);
        return dir;
    }

    public static String getMyDocUrl() {
        String id = UserUtils.getCurrentUserDTO().getId();
        return "/userdir/" + id + "/\u6211\u7684\u6587\u6863/";
    }

    public static String getAttachmentDir() {
        String id = UserUtils.getCurrentUserDTO().getId();
        String dir = JeePlusProperties.newInstance().getUserfilesBaseDir() + "/userdir/" + id + "/\u7a0b\u5e8f\u9644\u4ef6/";
        FileUtils.createDirectory((String)dir);
        return dir;
    }

    public static String getAttachmentUrl() {
        String id = UserUtils.getCurrentUserDTO().getId();
        return "/userdir/" + id + "/\u7a0b\u5e8f\u9644\u4ef6/";
    }

    public static String getFileSize(String fileDir) {
        File file = new File(fileDir);
        long size = file.length() * 100L;
        String label = (float)size == 0.0f ? "0" : (size < 102400L ? String.valueOf(size / 100L) + "b" : (size < 0x6400000L ? String.valueOf((float)(size / 1024L) / 100.0f) + "KB" : String.valueOf((float)(size / 0x100000L) / 100.0f) + "M"));
        return label;
    }
}

