/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.aop.demo;

import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.demo.exception.DemoException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class DemoAspect {
    private final Environment env;
    private final boolean demoMode;

    public DemoAspect(Environment env, boolean demoMode) {
        this.env = env;
        this.demoMode = demoMode;
    }

    public HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
    }

    @Pointcut(value="within(com.jeeplus..controller..*)")
    public void applicationPackagePointcut() {
    }

    private Logger logger(JoinPoint joinPoint) {
        return LoggerFactory.getLogger((String)joinPoint.getSignature().getDeclaringTypeName());
    }

    @Before(value="applicationPackagePointcut()")
    public void logAfterThrowing(JoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (this.demoMode && method.getAnnotation(DemoMode.class) != null) {
            throw new DemoException("\u6f14\u793a\u6a21\u5f0f\uff0c\u7981\u6b62\u6b64\u64cd\u4f5c!");
        }
    }
}

