/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.converter.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import net.sf.json.JSONNull;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class JsonMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JsonMapper() {
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule netSfJsonModule = new SimpleModule("net.sf.json");
        netSfJsonModule.addSerializer(JSONNull.class, (JsonSerializer)NullSerializer.instance);
        this.registerModule((Module)netSfJsonModule);
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeString("");
            }
        });
        this.registerModule((Module)new SimpleModule().addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){

            public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeString(value);
            }
        }));
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
    }
}

