/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.controller;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.common.utils.FileUtils;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.file.config.FileProperties;
import com.jeeplus.file.utils.FileKit;
import com.jeeplus.sys.model.FileData;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6587\u4ef6\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/file/filemanager"})
public class FileManagerController {
    @Autowired
    FileProperties fileProperties;

    public void init() {
        FileUtils.createDirectory((String)FileKit.getAttachmentDir());
        FileUtils.createDirectory((String)FileKit.getMyDocDir());
        FileUtils.createDirectory((String)FileKit.getShareBaseDir());
    }

    @ApiLog(value="\u67e5\u8be2\u6587\u4ef6\u5217\u8868")
    @GetMapping(value={"list"})
    public ResponseEntity<List<FileData>> data() {
        this.init();
        ArrayList targetFiles = Lists.newArrayList();
        targetFiles.add(new File(FileKit.getAttachmentDir()));
        targetFiles.add(new File(FileKit.getMyDocDir()));
        targetFiles.add(new File(FileKit.getShareBaseDir()));
        return ResponseEntity.ok(FileKit.getFileList("files", Lists.newArrayList((Iterable)targetFiles)));
    }

    @ApiLog(value="\u79fb\u52a8\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939")
    @RequestMapping(value={"move"})
    public ResponseEntity<List> move(@Param(value="source") String source, @Param(value="target") String target) throws IOException {
        String[] sourceArra;
        ArrayList list = Lists.newArrayList();
        target = FileKit.getFileDir(target);
        for (String s : sourceArra = source.split(",")) {
            HashMap<String, String> map;
            s = FileKit.getFileDir(s);
            String fileName = StrUtil.subAfter((CharSequence)s.replace("\\", "/"), (CharSequence)"/", (boolean)true);
            if (FileUtils.isFolder((String)s)) {
                File targetFolder = FileUtils.getAvailableFolder((String)(target + "/" + fileName), (int)0);
                FileUtils.moveDirectory((File)new File(s), (File)targetFolder);
                map = new HashMap<String, String>();
                map.put("id", FileKit.transDirToUrl(targetFolder.getAbsolutePath()));
                map.put("value", targetFolder.getName());
                list.add(map);
                continue;
            }
            File targetFile = FileUtils.getAvailableFile((String)(target + "/" + fileName), (int)0);
            FileUtils.moveFile((File)new File(s), (File)targetFile);
            new File(s).deleteOnExit();
            map = new HashMap();
            map.put("id", FileKit.transDirToUrl(targetFile.getAbsolutePath()));
            map.put("value", targetFile.getName());
            list.add(map);
        }
        return ResponseEntity.ok((Object)list);
    }

    @ApiLog(value="copy\u6587\u4ef6\u4ee5\u53ca\u6587\u4ef6\u5939")
    @RequestMapping(value={"copy"})
    public ResponseEntity<List> copy(@Param(value="source") String source, @Param(value="target") String target) {
        String[] sourceArra;
        ArrayList list = Lists.newArrayList();
        for (String s : sourceArra = source.split(",")) {
            HashMap<String, String> map;
            s = FileKit.getFileDir(s);
            String fileName = StrUtil.subAfter((CharSequence)s.replace("\\", "/"), (CharSequence)"/", (boolean)true);
            if (FileUtils.isFolder((String)s)) {
                File targetFolder = FileUtils.getAvailableFolder((String)(target + "/" + fileName), (int)0);
                if (!FileUtils.copyDirectory((String)s, (String)targetFolder.getAbsolutePath())) continue;
                map = new HashMap<String, String>();
                map.put("id", FileKit.transDirToUrl(targetFolder.getAbsolutePath()));
                map.put("value", targetFolder.getName());
                list.add(map);
                continue;
            }
            File targetFile = FileUtils.getAvailableFile((String)(target + "/" + fileName), (int)0);
            if (!FileUtils.copyFile((String)s, (String)targetFile.getAbsolutePath())) continue;
            map = new HashMap();
            map.put("id", FileKit.transDirToUrl(targetFile.getAbsolutePath()));
            map.put("value", targetFile.getName());
            list.add(map);
        }
        return ResponseEntity.ok((Object)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiLog(value="\u4e0b\u8f7d\u6587\u4ef6")
    @RequestMapping(value={"download"})
    public void download(@Param(value="source") String source, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file = new File(source = FileKit.getFileDir(source));
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("\u8bf7\u6c42\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        OutputStream out = null;
        try {
            response.reset();
            response.setContentType("application/octet-stream; charset=utf-8");
            String agent = request.getHeader("USER-AGENT");
            String fileName = file.getName();
            if (agent != null && agent.indexOf("MSIE") == -1) {
                String enableFileName = "=?UTF-8?B?" + new String(Base64.getEncoder().encode(fileName.getBytes("UTF-8"))) + "?=";
                response.setHeader("Content-Disposition", "attachment; filename=" + enableFileName);
            } else {
                String enableFileName = new String(fileName.getBytes("GBK"), "ISO-8859-1");
                response.setHeader("Content-Disposition", "attachment; filename=" + enableFileName);
            }
            out = response.getOutputStream();
            out.write(FileUtils.readFileToByteArray((File)file));
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @ApiLog(value="\u5220\u9664\u6587\u4ef6")
    @RequestMapping(value={"remove"})
    public ResponseEntity<List> delete(@Param(value="source") String source) {
        String[] sourceArra;
        ArrayList list = Lists.newArrayList();
        for (String s : sourceArra = source.split(",")) {
            s = FileKit.getFileDir(s);
            FileUtils.delFile((String)s);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", FileKit.transDirToUrl(s));
            map.put("value", StrUtil.subAfter((CharSequence)s.replace("\\", "/"), (CharSequence)"/", (boolean)true));
            list.add(map);
        }
        return ResponseEntity.ok((Object)list);
    }

    @ApiLog(value="\u521b\u5efa\u6587\u4ef6\u5939")
    @RequestMapping(value={"createFolder"})
    public ResponseEntity<Map> create(@Param(value="source") String source, @Param(value="target") String target) {
        HashMap<String, String> map = new HashMap<String, String>();
        String targetFolderPath = (target = FileKit.getFileDir(target)) + "/" + source;
        File targetFolder = FileUtils.getAvailableFolder((String)targetFolderPath, (int)0);
        boolean result = FileUtils.createDirectory((String)targetFolder.getAbsolutePath());
        if (result) {
            map.put("id", FileKit.transDirToUrl(targetFolder.getAbsolutePath()));
            map.put("value", targetFolder.getName());
        }
        return ResponseEntity.ok(map);
    }

    @ApiLog(value="\u91cd\u547d\u540d\u6587\u4ef6")
    @RequestMapping(value={"rename"})
    public ResponseEntity<Map> rename(@Param(value="source") String source, @Param(value="target") String target) {
        HashMap<String, String> map = new HashMap<String, String>();
        source = FileKit.getFileDir(source);
        File sourceFile = new File(source);
        File targetFile = new File(sourceFile.getParent() + "/" + target);
        targetFile = sourceFile.isDirectory() ? FileUtils.getAvailableFolder((String)targetFile.getAbsolutePath(), (int)0) : FileUtils.getAvailableFile((String)targetFile.getAbsolutePath(), (int)0);
        boolean result = sourceFile.renameTo(targetFile);
        if (result) {
            map.put("id", FileKit.transDirToUrl(targetFile.getAbsolutePath()));
            map.put("value", targetFile.getName());
        }
        return ResponseEntity.ok(map);
    }

    @ApiLog(value="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"upload"})
    public ResponseEntity<Map> upload(HttpServletRequest request, MultipartFile upload) throws Exception {
        String target = request.getParameter("target");
        String realPath = FileKit.getFileDir(target);
        HashMap<String, String> map = new HashMap<String, String>();
        if (!upload.isEmpty()) {
            String name = upload.getOriginalFilename();
            if (this.fileProperties.isAvailable(name)) {
                FileUtils.createDirectory((String)realPath);
                String filePath = realPath + "/" + name;
                File newFile = FileUtils.getAvailableFile((String)filePath, (int)0);
                upload.transferTo(newFile);
                map.put("id", FileKit.transDirToUrl(newFile.getAbsolutePath()));
                map.put("value", newFile.getName());
                map.put("type", FileKit.getFileType(newFile.getName()));
            } else {
                map.put("id", "");
                map.put("value", "");
                map.put("type", "");
                System.out.println("\u975e\u6cd5\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20!");
            }
        }
        return ResponseEntity.ok(map);
    }

    @ApiLog(value="\u83b7\u53d6\u6587\u4ef6\u7f51\u7edc\u5730\u5740")
    @GetMapping(value={"getUrl"})
    public ResponseEntity getUrl(HttpServletRequest request) {
        String dir = request.getParameter("dir");
        String type = FileKit.getFileType(dir);
        return ResponseUtil.newInstance().add("url", (Object)dir).add("type", (Object)type).ok();
    }
}

