/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.sys.domain.SysConfig;
import com.jeeplus.sys.domain.vo.SysConfigVo;
import com.jeeplus.sys.service.SysConfigService;
import com.jeeplus.sys.service.mapstruct.SysConfigWrapper;
import com.jeeplus.sys.utils.SmsUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysConfig"})
public class ConfigController {
    @Autowired
    private SysConfigService sysConfigService;

    @ApiLog(value="\u67e5\u8be2\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById() {
        SysConfig config = this.sysConfigService.getById("1");
        return ResponseEntity.ok((Object)config);
    }

    @ApiLog(value="\u67e5\u8be2\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"getConfig"})
    public ResponseEntity getConfig() {
        SysConfig sysConfig = this.sysConfigService.getById("1");
        SysConfigVo vo = SysConfigWrapper.INSTANCE.toVo(sysConfig);
        return ResponseEntity.ok((Object)vo);
    }

    @GetMapping(value={"testSms"})
    public ResponseEntity testSms(@RequestParam(value="tel") String tel) throws ClientException {
        SendSmsResponse response = SmsUtils.sendSms(tel, "{code:123}");
        if (response.getCode() != null && response.getCode().equals("OK")) {
            return ResponseEntity.ok((Object)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f!");
        }
        return ResponseEntity.badRequest().body((Object)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25!" + response.getMessage()));
    }

    @DemoMode
    @ApiLog(value="\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e")
    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody SysConfig config) {
        if (config.getMultiAccountLogin() == null) {
            config.setMultiAccountLogin("1");
        }
        config.setId("1");
        this.sysConfigService.updateById(config);
        SysConfig target = this.sysConfigService.getById("1");
        return ResponseUtil.newInstance().add("config", (Object)target).ok("\u4fdd\u5b58\u7cfb\u7edf\u914d\u7f6e\u6210\u529f");
    }
}

