/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.sys.domain.DataRule;
import com.jeeplus.sys.domain.Menu;
import com.jeeplus.sys.service.DataRuleService;
import com.jeeplus.sys.service.MenuService;
import com.jeeplus.sys.service.dto.DataRuleDTO;
import com.jeeplus.sys.service.dto.MenuDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/dataRule"})
public class DataRuleController {
    @Autowired
    private DataRuleService dataRuleService;
    @Autowired
    private MenuService menuService;

    @ApiLog(value="\u67e5\u8be2\u6570\u636e\u6743\u9650\u5217\u8868")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<DataRule>> data(DataRule dataRule, Page<DataRule> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)dataRule, DataRule.class);
        IPage result = this.dataRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok().body((Object)result);
    }

    @ApiLog(value="\u67e5\u8be2\u6570\u636e\u6743\u9650")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DataRule> queryById(String id) {
        DataRule dataRule = (DataRule)this.dataRuleService.getById((Serializable)((Object)id));
        return ResponseEntity.ok().body((Object)dataRule);
    }

    @ApiLog(value="\u4fdd\u5b58\u6570\u636e\u6743\u9650")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody DataRule dataRule) {
        this.dataRuleService.saveOrUpdate(dataRule);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6570\u636e\u6743\u9650\u6210\u529f!");
    }

    @ApiLog(value="\u5220\u9664\u6570\u636e\u6743\u9650")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String id) {
        this.dataRuleService.delete(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6570\u636e\u6743\u9650\u6210\u529f");
    }

    public List<Map<String, Object>> getTreeMenu(List<Map<String, Object>> list) {
        ArrayList rootTree = Lists.newArrayList();
        Menu menu = this.menuService.getById("1");
        HashMap map = Maps.newHashMap();
        map.put("id", menu.getId());
        map.put("name", menu.getName());
        map.put("parentId", "0");
        rootTree.add(this.getChildOfTree(map, list));
        return rootTree;
    }

    private Map<String, Object> getChildOfTree(Map<String, Object> menuItem, List<Map<String, Object>> menuList) {
        menuItem.put("children", Lists.newArrayList());
        for (Map<String, Object> child : menuList) {
            if (!child.get("parentId").equals(menuItem.get("id"))) continue;
            ((List)menuItem.get("children")).add(this.getChildOfTree(child, menuList));
        }
        return menuItem;
    }

    @ApiLog(value="\u67e5\u8be2\u6570\u636e\u6743\u9650\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List> treeData() {
        ArrayList mapList = Lists.newArrayList();
        List<MenuDTO> list = this.menuService.findAllWithDataRuleList();
        HashSet<String> existIdSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            String[] parentIds;
            MenuDTO menuDTO = list.get(i);
            if (menuDTO.getIsShow().equals("0")) continue;
            HashMap map = Maps.newHashMap();
            map.put("id", menuDTO.getId());
            map.put("name", menuDTO.getName());
            map.put("parentId", menuDTO.getParentId());
            map.put("parentIds", menuDTO.getParentIds());
            if (StrUtil.isNotBlank((CharSequence)menuDTO.getIcon())) {
                map.put("icon", menuDTO.getIcon());
            }
            boolean existDataRule = false;
            List<DataRuleDTO> dataRuleDTOList = menuDTO.getDataRuleDTOList();
            for (DataRuleDTO dataRuleDTO : dataRuleDTOList) {
                HashMap dataRuleMap = Maps.newHashMap();
                dataRuleMap.put("id", "dataRule-" + dataRuleDTO.getId());
                dataRuleMap.put("name", dataRuleDTO.getName());
                dataRuleMap.put("parentId", dataRuleDTO.getMenuId());
                dataRuleMap.put("parentIds", dataRuleDTO.getMenuId());
                mapList.add(dataRuleMap);
                existDataRule = true;
            }
            if (!existDataRule) continue;
            if (!existIdSet.contains(menuDTO.getId())) {
                mapList.add(map);
                existIdSet.add(menuDTO.getId());
            }
            for (String parentId : parentIds = menuDTO.getParentIds() == null ? new String[]{} : menuDTO.getParentIds().split(",")) {
                if (existIdSet.contains(parentId)) continue;
                existIdSet.add(parentId);
                Menu parentMenu = this.menuService.getById(parentId);
                if (parentMenu == null) continue;
                HashMap parentMenuMap = Maps.newHashMap();
                parentMenuMap.put("id", parentId);
                parentMenuMap.put("name", parentMenu.getName());
                parentMenuMap.put("parentId", parentMenu.getParentId());
                parentMenuMap.put("parentIds", parentMenu.getParentIds());
                mapList.add(parentMenuMap);
            }
        }
        List<Map<String, Object>> rootTree = this.getTreeMenu(mapList);
        return ResponseEntity.ok(rootTree);
    }
}

