/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.tree.controller;

import com.google.common.collect.Lists;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.test.tree.service.TestTreeService;
import com.jeeplus.test.tree.service.dto.TestTreeDTO;
import com.jeeplus.test.tree.service.mapstruct.TestTreeWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784"})
@RestController
@RequestMapping(value={"/test/tree/testTree"})
public class TestTreeController {
    @Autowired
    private TestTreeService testTreeService;
    @Autowired
    private TestTreeWrapper testTreeWrapper;

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:tree:testTree:view','test:tree:testTree:add','test:tree:testTree:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<TestTreeDTO> queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.testTreeService.findById(id)));
    }

    @ApiLog(value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784")
    @PreAuthorize(value="hasAnyAuthority('test:tree:testTree:add','test:tree:testTree:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody TestTreeDTO testTreeDTO) {
        this.testTreeService.saveOrUpdate(this.testTreeWrapper.toEntity(testTreeDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @PreAuthorize(value="hasAuthority('test:tree:testTree:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.testTreeService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u6210\u529f");
    }

    @ApiLog(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<TestTreeDTO>> treeData(String extId) {
        List rootTree = this.testTreeService.treeDataDTO(extId);
        return ResponseEntity.ok((Object)rootTree);
    }
}

