/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.service.TreeService;
import com.jeeplus.sys.domain.Menu;
import com.jeeplus.sys.mapper.MenuMapper;
import com.jeeplus.sys.service.DataRuleService;
import com.jeeplus.sys.service.dto.MenuDTO;
import com.jeeplus.sys.service.mapstruct.MenuWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MenuService
extends TreeService<MenuMapper, Menu> {
    @Autowired
    private DataRuleService dataRuleService;
    @Autowired
    private MenuWrapper menuWrapper;

    public List<MenuDTO> findList() {
        return this.menuWrapper.toDTO(((LambdaQueryChainWrapper)super.lambdaQuery().orderByAsc(TreeEntity::getSort)).list());
    }

    public Menu getById(String id) {
        return (Menu)super.getById((Serializable)((Object)id));
    }

    public List<MenuDTO> findByUserId(String userId) {
        MenuDTO menuDTO = new MenuDTO();
        menuDTO.setUserId(userId);
        return ((MenuMapper)this.baseMapper).findByUserId(menuDTO);
    }

    public List<MenuDTO> findAllWithDataRuleList() {
        return ((MenuMapper)this.baseMapper).findAllWithDataRuleList();
    }

    @Override
    @CacheEvict(cacheNames={"sys:cache:menu", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public boolean saveOrUpdate(Menu menu) {
        return super.saveOrUpdate(menu);
    }

    @CacheEvict(cacheNames={"sys:cache:menu", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public void deleteById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"a.menu_id", (Object)id);
        queryWrapper.or();
        queryWrapper.like((Object)"menu.parent_ids", (Object)("," + id + ","));
        List<String> mrList = ((MenuMapper)this.baseMapper).mrList((Wrapper)queryWrapper);
        for (String mr : mrList) {
            ((MenuMapper)this.baseMapper).deleteMenuRole(mr);
        }
        List<String> mdList = ((MenuMapper)this.baseMapper).mdList((Wrapper)queryWrapper);
        for (String dataRuleId : mdList) {
            this.dataRuleService.delete(dataRuleId);
        }
        super.removeWithChildrenById(id);
    }

    public List<MenuDTO> getTreeMenu(List<MenuDTO> list, String extId, String isShowHide) {
        Menu menu = (Menu)super.getById((Serializable)((Object)"1"));
        List<MenuDTO> rootTree = this.formatListToTree((MenuDTO)this.menuWrapper.toDTO(menu), list, extId, isShowHide);
        return rootTree;
    }

    public List<MenuDTO> formatListToTree(MenuDTO rootDTO, List<MenuDTO> allList, String extId, String isShowHide) {
        String rootId = rootDTO.getId();
        ArrayList trees = Lists.newArrayList();
        HashMap treeMap = Maps.newHashMap();
        for (MenuDTO menuDTO : allList) {
            List menuDTOs = (List)treeMap.get(((MenuDTO)menuDTO.getParent()).getId());
            if (menuDTOs == null) {
                menuDTOs = Lists.newLinkedList();
            }
            if (!StrUtil.isBlank((CharSequence)extId) && (extId.equals(menuDTO.getId()) || menuDTO.getParentIds() != null && menuDTO.getParentIds().indexOf("," + extId + ",") != -1) || isShowHide.equals("0") && "0".equals(menuDTO.getIsShow())) continue;
            menuDTOs.add(menuDTO);
            treeMap.put(((MenuDTO)menuDTO.getParent()).getId(), menuDTOs);
        }
        if (treeMap.get(rootId) == null || ((List)treeMap.get(rootId)).isEmpty()) {
            return trees;
        }
        List children = (List)treeMap.get(rootId);
        for (MenuDTO parent : children) {
            this.formatFillChildren(parent, treeMap);
            trees.add(parent);
        }
        if (StrUtil.equals((CharSequence)rootId, (CharSequence)MenuDTO.getRootId())) {
            return children;
        }
        rootDTO.setChildren(trees);
        return Lists.newArrayList((Object[])new MenuDTO[]{rootDTO});
    }

    private void formatFillChildren(MenuDTO parent, Map<String, List<MenuDTO>> treeMap) {
        List<MenuDTO> children = treeMap.get(parent.getId());
        parent.setChildren(children);
        if (children != null && !children.isEmpty()) {
            for (MenuDTO child : children) {
                this.formatFillChildren(child, treeMap);
            }
        }
    }
}

