/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.google.common.collect.Lists;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.security.util.SecurityUtils;
import com.jeeplus.sys.service.DataRuleService;
import com.jeeplus.sys.service.MenuService;
import com.jeeplus.sys.service.UserService;
import com.jeeplus.sys.service.dto.DataRuleDTO;
import com.jeeplus.sys.service.dto.MenuDTO;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.service.mapstruct.MenuWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserUtils {
    public static UserDTO get(String id) {
        UserDTO userDTO = (UserDTO)RedisUtils.getInstance().get("user:cache:userId", id);
        if (userDTO == null) {
            userDTO = ((UserService)((Object)SpringUtil.getBean(UserService.class))).get(id);
        }
        return userDTO;
    }

    @InterceptorIgnore
    public static UserDTO getByLoginName(String loginName) {
        UserDTO userDTO = ((UserService)((Object)SpringUtil.getBean(UserService.class))).getUserByLoginName(loginName);
        return userDTO;
    }

    public static void deleteCache(UserDTO userDTO) {
        RedisUtils.getInstance().delete("user:cache:userId", userDTO.getId());
        RedisUtils.getInstance().delete("user:cache:dataRuleList", userDTO.getId());
        RedisUtils.getInstance().delete("user:cache:menuList", userDTO.getId());
        RedisUtils.getInstance().delete("user:cache:roleList", userDTO.getId());
        RedisUtils.getInstance().delete("user:cache:topMenu", userDTO.getId());
        RedisUtils.getInstance().delete("user:cache:loginName", userDTO.getLoginName());
        RedisUtils.getInstance().delete("user:cache:loginName", userDTO.getOldLoginName());
    }

    public static UserDTO getCurrentUserDTO() {
        String username = SecurityUtils.getLoginName();
        if (StrUtil.isNotEmpty((CharSequence)username)) {
            return UserUtils.getByLoginName(username);
        }
        return new UserDTO();
    }

    public static List<RoleDTO> getRoleDTOList() {
        return UserUtils.getCurrentUserDTO().getRoleDTOList();
    }

    public static List<MenuDTO> getMenuDTOList() {
        String loginName = SecurityUtils.getLoginName();
        return UserUtils.getMenuDTOListByLoginName(loginName);
    }

    public static List<MenuDTO> getMenuDTOListByLoginName(String loginName) {
        UserDTO user = UserUtils.getByLoginName(loginName);
        List<MenuDTO> menuDTOList = (List<MenuDTO>)RedisUtils.getInstance().get("user:cache:menuList", user.getId());
        if (menuDTOList == null) {
            menuDTOList = user.isAdmin() ? ((MenuService)((Object)SpringUtil.getBean(MenuService.class))).findList() : ((MenuService)((Object)SpringUtil.getBean(MenuService.class))).findByUserId(user.getId());
            RedisUtils.getInstance().set("user:cache:menuList", user.getId(), menuDTOList);
        }
        return menuDTOList;
    }

    public static List<DataRuleDTO> getDataRuleList() {
        UserDTO userDTO = UserUtils.getCurrentUserDTO();
        if (userDTO.isAdmin()) {
            return Lists.newArrayList();
        }
        return ((DataRuleService)((Object)SpringUtil.getBean(DataRuleService.class))).findByUserId(userDTO);
    }

    public static MenuDTO getTopMenuDTO() {
        MenuDTO topMenuDTO = (MenuDTO)RedisUtils.getInstance().get("user:cache:topMenu", UserUtils.getCurrentUserDTO().getId());
        if (topMenuDTO == null) {
            topMenuDTO = (MenuDTO)MenuWrapper.INSTANCE.toDTO(((MenuService)((Object)SpringUtil.getBean(MenuService.class))).getById("1"));
            RedisUtils.getInstance().set("user:cache:topMenu", UserUtils.getCurrentUserDTO().getId(), (Object)topMenuDTO);
        }
        return topMenuDTO;
    }

    public static Set<String> getPermissionsByLoginName(String loginName) {
        HashSet<String> info = new HashSet<String>();
        List<MenuDTO> list = UserUtils.getMenuDTOListByLoginName(loginName);
        for (MenuDTO menuDTO : list) {
            if (!StrUtil.isNotBlank((CharSequence)menuDTO.getPermission())) continue;
            for (String permission : StrUtil.split((CharSequence)menuDTO.getPermission(), (CharSequence)",")) {
                info.add(permission);
            }
        }
        return info;
    }

    public static Set<String> getPermissions() {
        String loginName = SecurityUtils.getLoginName();
        return UserUtils.getPermissionsByLoginName(loginName);
    }

    public static boolean isCheckLoginName(String oldLoginName, String loginName) {
        if (loginName != null && loginName.equals(oldLoginName)) {
            return true;
        }
        return loginName != null && ((UserService)((Object)SpringUtil.getBean(UserService.class))).getUserByLoginName(loginName) == null;
    }
}

