/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.datav.controller;

import com.google.common.collect.Lists;
import com.jeeplus.datav.domain.DataScreenCategory;
import com.jeeplus.datav.service.DataScreenCategoryService;
import com.jeeplus.datav.service.dto.DataScreenCategoryDTO;
import com.jeeplus.datav.service.mapstruct.DataScreenCategoryWrapper;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datav/dataScreenCategory"})
public class DataScreenCategoryController {
    @Autowired
    private DataScreenCategoryService dataScreenCategoryService;
    @Autowired
    private DataScreenCategoryWrapper dataScreenCategoryWrapper;

    @PreAuthorize(value="hasAnyAuthority('datav:dataScreenCategory:view','datav:dataScreenCategory:add','datav:dataScreenCategory:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<DataScreenCategoryDTO> queryById(String id) {
        DataScreenCategory dataScreenCategory = (DataScreenCategory)((Object)this.dataScreenCategoryService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)this.dataScreenCategoryWrapper.toDTO((Object)dataScreenCategory));
    }

    @PreAuthorize(value="hasAnyAuthority('datav:dataScreenCategory:add','datav:dataScreenCategory:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@RequestBody @Valid DataScreenCategoryDTO dataScreenCategoryDTO) {
        DataScreenCategory dataScreenCategory = (DataScreenCategory)((Object)this.dataScreenCategoryWrapper.toEntity((Object)dataScreenCategoryDTO));
        this.dataScreenCategoryService.saveOrUpdate(dataScreenCategory);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5927\u5c4f\u5206\u7c7b\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('datav:dataScreenCategory:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.dataScreenCategoryService.removeWithChildrenByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5927\u5c4f\u5206\u7c7b\u6210\u529f");
    }

    @GetMapping(value={"treeData"})
    public ResponseEntity<List<DataScreenCategory>> treeData(@RequestParam(required=false) String extId) {
        List rootTrees = this.dataScreenCategoryService.treeData(extId);
        return ResponseEntity.ok((Object)rootTrees);
    }
}

