/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.aop.logging.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.jeeplus.aop.logging.annotation.ApiLog;
import com.jeeplus.security.jwt.TokenProvider;
import com.jeeplus.sys.constant.enums.LogTypeEnum;
import com.jeeplus.sys.domain.Log;
import com.jeeplus.sys.service.dto.UserDTO;
import com.jeeplus.sys.utils.UserUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class LogUtils {
    public static String getRequestParams(Map paramMap) {
        HashMap map = new HashMap();
        if (paramMap == null) {
            return "";
        }
        for (Map.Entry param : paramMap.entrySet()) {
            String paramValue = param.getValue() != null && ((String[])param.getValue()).length > 0 ? ((String[])param.getValue())[0] : "";
            map.put(param.getKey(), StringUtils.abbreviate((String)(StringUtils.endsWithIgnoreCase((CharSequence)((CharSequence)param.getKey()), (CharSequence)"password") ? "\u5b89\u5168\u8003\u8651\uff0c\u5bc6\u7801\u5df2\u9690\u85cf" : paramValue), (int)100));
        }
        return JSONUtil.toJsonStr(map);
    }

    public static Log getLog(HttpServletRequest request, JoinPoint joinPoint, long recordTime, String result, Throwable e) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiLog aopLog = method.getAnnotation(ApiLog.class);
        String functionName = aopLog.value();
        LogTypeEnum logTypeEnum = aopLog.type();
        String userId = null;
        String token = TokenProvider.resolveToken(request);
        String loginName = TokenProvider.getLoginName(token);
        if (StrUtil.isNotEmpty((CharSequence)loginName)) {
            UserDTO user = UserUtils.getByLoginName(loginName);
            userId = user != null ? user.getId() : null;
        }
        Log log = new Log();
        log.setRecordTime(recordTime);
        log.setTitle(functionName);
        log.setType(logTypeEnum.getValue());
        log.setRemoteAddr(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        log.setUserAgent(request.getHeader("user-agent"));
        log.setRequestUri(request.getRequestURI());
        log.setRequestType(request.getMethod());
        log.setMethod(joinPoint.getSignature().toString());
        log.setParams(LogUtils.getRequestParams(request.getParameterMap()));
        log.setResult(result);
        log.setCreateBy(userId);
        String exception = "";
        if (e != null) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            exception = stringWriter.toString();
            log.setException(exception);
            log.setResult(e.getMessage());
            if (!log.getType().equals(LogTypeEnum.LOGIN.getValue())) {
                log.setType(LogTypeEnum.EXCEPTION.getValue());
            }
        }
        return log;
    }
}

