/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datalink.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.database.DataSourceConfig;
import com.jeeplus.database.datalink.domain.DataSource;
import com.jeeplus.database.datalink.domain.vo.DataSourceTreeVO;
import com.jeeplus.database.datalink.jdbc.DBPool;
import com.jeeplus.database.datalink.service.DataSourceService;
import com.jeeplus.database.datalink.service.mapstruct.DataSourceWrapper;
import com.jeeplus.sys.utils.DictUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/database/datalink/dataSource"})
public class DataSourceController {
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DatabaseIdProvider databaseIdProvider;
    @Autowired
    private DataSourceConfig dataSourceConfig;

    @PreAuthorize(value="hasAnyAuthority('database:datalink:dataSource:view','database:datalink:dataSource:add','database:datalink:dataSource:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id) {
        return ResponseEntity.ok((Object)((Object)this.dataSourceService.getById(id)));
    }

    @PreAuthorize(value="hasAuthority('database:datalink:dataSource:list')")
    @GetMapping(value={"list"})
    public ResponseEntity list(DataSource dataSource, Page<DataSource> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)dataSource), DataSource.class);
        IPage result = this.dataSourceService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"treeData"})
    public ResponseEntity treeData2() {
        String dbType;
        ArrayList treeList = Lists.newArrayList();
        ArrayList treeRoots = Lists.newArrayList();
        try {
            dbType = this.databaseIdProvider.getDatabaseId((javax.sql.DataSource)SpringUtil.getBean(javax.sql.DataSource.class));
        }
        catch (Exception e) {
            dbType = "mysql";
        }
        treeRoots.add(new DataSourceTreeVO("master-parent", "\u9ed8\u8ba4\u6570\u636e\u6e90", "0", "", "host", true));
        treeList.add(new DataSourceTreeVO(this.dataSourceConfig.primary, "\u672c\u5730\u6570\u636e\u5e93", "master-parent", this.dataSourceConfig.primary, "db", dbType));
        List list = ((LambdaQueryChainWrapper)this.dataSourceService.lambdaQuery().eq(DataSource::isEnable, (Object)true)).list();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            DataSource e = (DataSource)((Object)list.get(i));
            treeList.add(new DataSourceTreeVO(e.getId(), e.getName(), e.getHost(), e.getEnName(), "db", e.getType()));
            set.add(e.getHost());
        }
        for (String host : set) {
            treeRoots.add(new DataSourceTreeVO(host, host, "0", "", "host", true));
        }
        List<DataSourceTreeVO> rootTree = this.getRootTree(treeRoots, treeList);
        return ResponseEntity.ok(rootTree);
    }

    private List<DataSourceTreeVO> getRootTree(List<DataSourceTreeVO> rootTrees, List<DataSourceTreeVO> list) {
        ArrayList trees = Lists.newArrayList();
        for (DataSourceTreeVO root : rootTrees) {
            trees.add(this.getChildOfTree(root, list));
        }
        return trees;
    }

    private DataSourceTreeVO getChildOfTree(DataSourceTreeVO area, List<DataSourceTreeVO> areaList) {
        area.setChildren(Lists.newArrayList());
        for (DataSourceTreeVO child : areaList) {
            if (!child.getParentId().equals(area.getId())) continue;
            area.getChildren().add(this.getChildOfTree(child, areaList));
        }
        return area;
    }

    @PreAuthorize(value="hasAnyAuthority('database:datalink:dataSource:add','database:datalink:dataSource:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody DataSource dataSource) {
        String oldName = "";
        if (StrUtil.isNotBlank((CharSequence)dataSource.getId())) {
            oldName = this.dataSourceService.getById(dataSource.getId()).getEnName();
        }
        String driver = DictUtils.getDictValue((String)dataSource.getType(), (String)"db_driver", (String)"mysql");
        dataSource.setDriver(driver);
        dataSource.setUrl(this.dataSourceService.toUrl(dataSource.getType(), dataSource.getHost(), dataSource.getPort(), dataSource.getDatabaseName()));
        this.dataSourceService.saveOrUpdate((Object)dataSource);
        if (StrUtil.isNotBlank((CharSequence)oldName)) {
            DBPool.getInstance().remove(oldName);
        }
        DBPool.getInstance().addDs(DataSourceWrapper.INSTANCE.toDTO(dataSource));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('database:datalink:dataSource:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids", required=false) String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            DataSource dataSource = this.dataSourceService.getById(id);
            DBPool.getInstance().remove(dataSource.getEnName());
            this.dataSourceService.removeById((Serializable)((Object)id));
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
    }

    @GetMapping(value={"checkEnName"})
    public ResponseEntity<String> checkLoginName(@RequestParam(value="oldEnName", required=false) String oldEnName, @RequestParam(value="enName", required=false) String enName) {
        if (enName != null && enName.equals(oldEnName)) {
            return ResponseEntity.ok((Object)"\u9a8c\u8bc1\u901a\u8fc7!");
        }
        if (enName != null && ((LambdaQueryChainWrapper)this.dataSourceService.lambdaQuery().eq(DataSource::getEnName, (Object)enName)).one() == null) {
            return ResponseEntity.ok((Object)"\u9a8c\u8bc1\u901a\u8fc7!");
        }
        return ResponseEntity.badRequest().body((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u82f1\u6587\u540d\u5df2\u5b58\u5728");
    }

    @PostMapping(value={"/test"})
    public ResponseEntity test(@RequestBody DataSource dataSource) {
        if (StrUtil.isBlank((CharSequence)dataSource.getType()) || StrUtil.isBlank((CharSequence)dataSource.getHost()) || StrUtil.isBlank((CharSequence)dataSource.getDatabaseName()) || StrUtil.isBlank((CharSequence)dataSource.getUsername())) {
            return ResponseEntity.badRequest().body((Object)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u5168");
        }
        if (DBPool.getInstance().test(this.dataSourceService.getDriver(dataSource.getType()), this.dataSourceService.toUrl(dataSource.getType(), dataSource.getHost(), dataSource.getPort(), dataSource.getDatabaseName()), dataSource.getUsername(), dataSource.getPassword())) {
            return ResponseEntity.ok((Object)"\u8fde\u63a5\u6210\u529f");
        }
        return ResponseEntity.badRequest().body((Object)"\u8fde\u63a5\u5931\u8d25");
    }
}

